program Watchdog;

{$APPTYPE CONSOLE}

uses
  SysUtils, Libc,
  Main in 'Main.pas';

var
  pid: pid_t;
  Terminate: Boolean;

procedure sig_usr(signo: integer); cdecl;
begin
  if getpid = pid then
  begin
    Log('Terminating...');
    Writeln(#$0d#$0d+'Compex AP Watchdog: terminating...');
    ProgramEnd;
    Terminate := True;
  end;
end;

begin
  pid := fork;
  if pid < 0 then
  begin
    Writeln('Error forking thread!');
    Exit;
  end
  else if pid > 0 then
  begin
    Writeln('Compex AP Watchdog: starting...');
    Exit;
  end;

  pid := getpid;
  ProgramStart;

  signal(SIGQUIT, sig_usr);
  signal(SIGTERM, sig_usr);
  signal(SIGINT, sig_usr);

  Terminate := False;

  while not Terminate do pause;
end.
