unit fSetting;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Buttons, Inifiles;

type
  TPingRec = record
    Addr: string;
    CanReset: Boolean;
    Timeout: Integer;
    DispName: string;
  end;
  PPingRec = ^TPingRec;

  TSettingsForm = class(TForm)
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    edtMaxTimeouts: TEdit;
    edtInterval: TEdit;
    GroupBox3: TGroupBox;
    Label3: TLabel;
    edtResetHost: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    TabControl1: TTabControl;
    Label4: TLabel;
    edtAdrIP: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtAdrDisp: TEdit;
    edtAdrTO: TEdit;
    Label7: TLabel;
    chbAdrReset: TCheckBox;
    chbHeslo: TCheckBox;
    btnHeslo: TButton;
    procedure FormShow(Sender: TObject);
    procedure TabControl1Change(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure chbHesloClick(Sender: TObject);
    procedure btnHesloClick(Sender: TObject);
  private
  public
  end;

var
  SettingsForm: TSettingsForm;

implementation

uses Unit1;

{$R *.dfm}

function TestEdtVal(Edit: TEdit): Boolean;
begin
  Result := True;
  try
    StrToInt(Edit.Text);
  except
    Edit.SetFocus;
    MessageDlg('Nesprvn hodnota!', mtError, [mbOk], 0);
    Result := False;
  end;
end;

procedure TSettingsForm.FormShow(Sender: TObject);
var
  i: integer;
  x: PPingRec;
begin
  chbHeslo.Checked := EncryptedIni;
  chbHesloClick(chbHeslo);

  edtInterval.Text := IntToStr(cTimer);
  edtMaxTimeouts.Text := IntToStr(cNumTimeouts);
  edtResetHost.Text := ResetHost;

  TabControl1.Tabs.Clear;
  for i := 0 to cNumHosts-1 do
  begin
    new(x);
    x^.Addr := PingObjs[i].Addr;
    x^.CanReset := PingObjs[i].CanReset;
    x^.Timeout := PingThs[i].Timeout;
    x^.DispName := PingObjs[i].Disp;
    TabControl1.Tabs.AddObject('Adresa ' + IntToStr(i), TObject(x));
  end;

  TabControl1.TabIndex := 0;
  TabControl1.Tag := -1;
  TabControl1Change(TabControl1);
end;

procedure TSettingsForm.TabControl1Change(Sender: TObject);
var
  x: PPingRec;
begin
  if TabControl1.Tag <> -1 then
  begin
    x := PPingRec(TabControl1.Tabs.Objects[TabControl1.Tag]);

    if not TestEdtVal(edtAdrTo) then
    begin
      TabControl1.TabIndex := TabControl1.Tag;
      Exit;
    end;

    x^.Timeout := StrToInt(edtAdrTO.Text);
    x^.Addr := edtAdrIP.Text;
    x^.CanReset := chbAdrReset.Checked;
    x^.DispName := edtAdrDisp.Text;
  end;

  x := PPingRec(TabControl1.Tabs.Objects[TabControl1.TabIndex]);
  edtAdrIP.Text := x^.Addr;
  edtAdrDisp.Text := x^.DispName;
  edtAdrTO.Text := IntToStr(x^.Timeout);
  chbAdrReset.Checked := x^.CanReset;

  TabControl1.Tag := TabControl1.TabIndex;
end;

procedure TSettingsForm.BitBtn1Click(Sender: TObject);
var
  x: PPingRec;
  i: integer;
  crc: byte;
  Ini: TIniFile;
  fenc: file;
  buf: string;
begin
  if not TestEdtVal(edtAdrTO) then Exit;
  if not TestEdtVal(edtMaxTimeouts) then Exit;
  if not TestEdtVal(edtInterval) then Exit;

  x := PPingRec(TabControl1.Tabs.Objects[TabControl1.TabIndex]);
  x^.Timeout := StrToInt(edtAdrTO.Text);
  x^.Addr := edtAdrIP.Text;
  x^.CanReset := chbAdrReset.Checked;
  x^.DispName := edtAdrDisp.Text;

  if EncryptedIni and FileExists(CurDir + cIniEncFilename) then
    XorFile(CurDir + cIniEncFilename, CurDir + cIniFilename);

  EncryptedIni := chbHeslo.Checked;

  Ini := TIniFile.Create(CurDir + cIniFilename);
  cNumTimeouts := StrToInt(edtMaxTimeouts.Text);
  cTimer := StrToInt(edtInterval.Text);
  Ini.WriteInteger('Constants', 'MaxTimeouts', cNumTimeouts);
  Ini.WriteInteger('Constants', 'PingInterval', cTimer);

  ResetHost := edtResetHost.Text;
  Ini.WriteString('ResetHost', 'Hostname', ResetHost);

  for i := 0 to cNumHosts-1 do
  begin
    x := PPingRec(TabControl1.Tabs.Objects[i]);
    PingObjs[i].Disp := x^.DispName;
    case i+1 of
      1: MainForm.Host1.Caption := x^.DispName;
      2: MainForm.Host2.Caption := x^.DispName;
      3: MainForm.Host3.Caption := x^.DispName;
      4: MainForm.Host4.Caption := x^.DispName;
    end;
    PingObjs[i].Addr := WSGetHostByName(x^.Addr);
    PingThs[i].Host := WSGetHostByName(x^.Addr);
    PingThs[i].Timeout := x^.Timeout;
    PingObjs[i].CanReset := x^.CanReset;

    Ini.WriteString('Host' + IntToStr(i+1), 'HostName', x^.Addr);
    Ini.WriteString('Host' + IntToStr(i+1), 'DisplayName', x^.DispName);
    Ini.WriteInteger('Host' + IntToStr(i+1), 'Timeout', x^.Timeout);
    Ini.WriteBool('Host' + IntToStr(i+1), 'TimeoutDoReset', x^.CanReset);
  end;

  Ini.Free;

  if EncryptedIni then
  begin
    XorFile(CurDir + cIniFilename, CurDir + cIniEncFilename);
    DeleteFile(CurDir + cIniFileName);
  end;

  AssignFile(fenc, CurDir + cSecFileName);
  ReWrite(fenc,1);
  if EncryptedIni then buf := '1' + heslo
  else buf := '0' + MD5Heslo('');
  crc := 0;
  for i := 1 to Length(buf) do
  begin
    crc := crc xor Ord(buf[i]);
    buf[i] := Chr(Ord(buf[i]) xor (cXorConst*i));
  end;
  buf := buf + Chr(crc);
  BlockWrite(fenc, buf[1], Length(buf));
  CloseFile(fenc);

  ModalResult := mrOk;
end;

procedure TSettingsForm.chbHesloClick(Sender: TObject);
begin
  btnHeslo.Enabled := chbHeslo.Checked;
end;

procedure TSettingsForm.btnHesloClick(Sender: TObject);
var
  heslonew, heslo2: string;
begin
  if InputPassword('Nov heslo', 'Zadejte nov heslo:', heslonew) then
  begin
    if InputPassword('Nov heslo', 'Opakujte nov heslo:', heslo2) then
    begin
      if heslonew = heslo2 then
      begin
        MessageDlg('Nov heslo bylo uloeno.', mtInformation, [mbOk], 0);
        Heslo := MD5Heslo(heslonew);
      end
      else
        MessageDlg('Zadan hesla se neshoduj!', mtError, [mbOk], 0);
    end;
  end;
end;

end.
