/*
 *  Compex WP543/WPJ543 board support
 *
 *  Copyright (C) 2008-2009 Gabor Juhos <juhosg@openwrt.org>
 *  Copyright (C) 2008 Imre Kaloz <kaloz@openwrt.org>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 2 as published
 *  by the Free Software Foundation.
 */

#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>

#include <asm/mach-ar71xx/ar71xx.h>

#include "machtype.h"
#include "devices.h"
#include "dev-m25p80.h"
#include "dev-pb42-pci.h"
#include "dev-gpio-buttons.h"
#include "dev-leds-gpio.h"
#include "dev-usb.h"

#define WP546_GPIO_SW6		2
#define WP546_GPIO_LED_1	3
#define WP546_GPIO_LED_2	4
#define WP546_GPIO_LED_WLAN	5
#define WP546_GPIO_LED_CONN	6
#define WP546_GPIO_LED_DIAG	7
#define WP546_GPIO_SW4		8

#define WP546_BUTTONS_POLL_INTERVAL	20

static struct gpio_led wp546_leds_gpio[] __initdata = {
	{
		.name		= "wp546:green:led1",
		.gpio		= WP546_GPIO_LED_1,
		.active_low	= 1,
	}, {
		.name		= "wp546:green:led2",
		.gpio		= WP546_GPIO_LED_2,
		.active_low	= 1,
	}, {
		.name		= "wp546:green:wlan",
		.gpio		= WP546_GPIO_LED_WLAN,
		.active_low	= 1,
	}, {
		.name		= "wp546:green:conn",
		.gpio		= WP546_GPIO_LED_CONN,
		.active_low	= 1,
	}, {
		.name		= "wp546:green:diag",
		.gpio		= WP546_GPIO_LED_DIAG,
		.active_low	= 1,
	}
};

static struct gpio_button wp546_gpio_buttons[] __initdata = {
	{
		.desc		= "sw6",
		.type		= EV_KEY,
		.code		= BTN_0,
		.threshold	= 3,
		.gpio		= WP546_GPIO_SW6,
	}, {
		.desc		= "sw4",
		.type		= EV_KEY,
		.code		= BTN_1,
		.threshold	= 3,
		.gpio		= WP546_GPIO_SW4,
	}
};

#define WP546_WAN_PHY_MASK BIT(0)
#define WP546_LAN_PHY_MASK  BIT(1)
#define WP546_MDIO_BUS_MASK (~((WP546_WAN_PHY_MASK)|(WP546_LAN_PHY_MASK)))
static void __init wp546_setup(void)
{
	ar71xx_add_device_m25p80(NULL);


	
	ar71xx_add_device_mdio(WP546_MDIO_BUS_MASK);
	
	ar71xx_eth0_data.phy_if_mode = PHY_INTERFACE_MODE_RGMII;
	ar71xx_eth0_data.phy_mask = WP546_WAN_PHY_MASK;
	ar71xx_add_device_eth(0);

	ar71xx_eth1_data.phy_if_mode = PHY_INTERFACE_MODE_RGMII;
	ar71xx_eth1_data.phy_mask = WP546_LAN_PHY_MASK;
	ar71xx_add_device_eth(1);


	pb42_pci_init();

	ar71xx_add_device_leds_gpio(-1, ARRAY_SIZE(wp546_leds_gpio),
					wp546_leds_gpio);

	ar71xx_add_device_gpio_buttons(-1, WP546_BUTTONS_POLL_INTERVAL,
					ARRAY_SIZE(wp546_gpio_buttons),
					wp546_gpio_buttons);
}

MIPS_MACHINE(AR71XX_MACH_WP546, "WP546", "Compex WP546", wp546_setup);
