#include <stdlib.h>
#include <stdio.h>
#include "multi_ap.h"
#include "wifi_utils.h"
#include "p1905_database.h"
#include "p1905_managerd.h"
#include "debug.h"

int wapp_set_wireless_setting(struct p1905_managerd_ctx* ctx)
{
	int datalen = 0, i = 0;
	struct wsc_config* pautoconf = NULL;
	unsigned char radio_index = 0;
	unsigned char buf[1024] = {0};

	pautoconf = (struct wsc_config*)buf;
	if (ctx->current_autoconfig_info.radio_index != -1) {
		radio_index = (unsigned char)ctx->current_autoconfig_info.radio_index;
	} else {
		debug(DEBUG_ERROR, "radio_index error == -1!!!\n");
		return wapp_utils_error;
	}
	pautoconf->num = (ctx->current_autoconfig_info.config_number <=
		ctx->rinfo[radio_index].bss_number) ?
		ctx->current_autoconfig_info.config_number :
		ctx->rinfo[radio_index].bss_number;
	debug(DEBUG_OFF, "total autoconf num=%d\n", pautoconf->num);

	datalen = sizeof(struct wsc_config) + pautoconf->num * sizeof(struct wireless_setting);
	for(i = 0; i < pautoconf->num; i++)
	{
		pautoconf->setting[i].AuthMode = ctx->current_autoconfig_info.config_data[i].AuthMode;
		pautoconf->setting[i].EncrypType = ctx->current_autoconfig_info.config_data[i].EncrypType;
		memcpy(pautoconf->setting[i].mac_addr, ctx->rinfo[radio_index].bss[i].mac, ETH_ALEN);
		memcpy(pautoconf->setting[i].Ssid, ctx->current_autoconfig_info.config_data[i].Ssid, 33);
		memcpy(pautoconf->setting[i].WPAKey, ctx->current_autoconfig_info.config_data[i].WPAKey, 65);
		pautoconf->setting[i].map_vendor_extension = ctx->current_autoconfig_info.config_data[i].map_vendor_extension;
		ctx->rinfo[radio_index].bss[i].config_status = 1;
		debug(DEBUG_OFF, "mac=%02x:%02x:%02x:%02x:%02x:%02x authmode=0x%04x, Encryption=0x%04x, Ssid=%s, Key=%s, map_vendor_extension=0x%02x\n",
			PRINT_MAC(pautoconf->setting[i].mac_addr),
			pautoconf->setting[i].AuthMode, pautoconf->setting[i].EncrypType, pautoconf->setting[i].Ssid,
			pautoconf->setting[i].WPAKey, pautoconf->setting[i].map_vendor_extension);
	}

	if (0 > wapp_set_info_by_msgtype(ctx, WAPP_USER_SET_WIRELESS_SETTING, NULL,
				pautoconf, datalen)) {
		debug(DEBUG_ERROR, "WAPP_USER_SET_WIRELESS_SETTING fail\n");
		return wapp_utils_error;
	}

    return wapp_utils_success;
}

int wapp_set_info_by_msgtype(struct p1905_managerd_ctx *ctx, unsigned short msgtype, unsigned char *bssid,
	void *data, int datalen)
{
	struct cmd_to_wapp *wapp_msg = NULL;
	int msg_len = 0;

	msg_len = sizeof(*wapp_msg) + datalen;
	wapp_msg = (struct cmd_to_wapp *)malloc(msg_len);
	if (wapp_msg == NULL) {
		debug(DEBUG_ERROR, "alloc memory for msg(0x%04x) fail\n", msgtype);
		goto error0;
	}
	memset(wapp_msg, 0, msg_len);
	wapp_msg->type = msgtype;
	wapp_msg->role = !ctx->role;

	if (bssid)
		memcpy(wapp_msg->bssAddr, bssid, ETH_ALEN);
	if (data)
		memcpy(wapp_msg->body, data, datalen);

	if (0 > wapp_usr_intf_send_command(ctx, (char *)wapp_msg, msg_len)) {
		debug(DEBUG_ERROR, "send command for msg(0x%04x) fail\n", msgtype);
		goto error1;
	}

	free(wapp_msg);
    return wapp_utils_success;

error1:
	free(wapp_msg);
error0:
	return wapp_utils_error;
}

void wapp_set_steering_policy_setting(struct p1905_managerd_ctx *ctx, struct steer_policy *spolicy)
{
	int datalen = 0;
	struct local_disallow_sta_head *sta_head = NULL;
	struct btm_disallow_sta_head *btm_sta_head = NULL;
	struct radio_policy_head *radio_head = NULL;
	struct radio_policy *policy = NULL;
	struct sta_db *sta = NULL;
	struct radio_policy_db *policy_db = NULL;
	unsigned char *mac = NULL;
	unsigned char buf[128] = {0};

	if (spolicy->local_disallow_count) {
		datalen = spolicy->local_disallow_count * ETH_ALEN + 1;
		sta_head = (struct local_disallow_sta_head *)buf;
		sta_head->sta_cnt = spolicy->local_disallow_count;
		mac = sta_head->sta_list;
        SLIST_FOREACH(sta, &spolicy->local_disallow_head, sta_entry)
        {
      		memcpy(mac, sta->mac, ETH_ALEN);
			mac += ETH_ALEN;
        }
		wapp_set_info_by_msgtype(ctx, WAPP_USER_SET_LOCAL_STEER_DISALLOW_STA, NULL,
			(void *)sta_head, datalen);
	}

	if (spolicy->btm_disallow_count) {
		datalen = spolicy->btm_disallow_count * ETH_ALEN + 1;
		btm_sta_head = (struct btm_disallow_sta_head *)buf;
		btm_sta_head->sta_cnt = spolicy->btm_disallow_count;
		mac = btm_sta_head->sta_list;
        SLIST_FOREACH(sta, &spolicy->btm_disallow_head, sta_entry)
        {
      		memcpy(mac, sta->mac, ETH_ALEN);
			mac += ETH_ALEN;
        }
		wapp_set_info_by_msgtype(ctx, WAPP_USER_SET_BTM_STEER_DISALLOW_STA, NULL,
			(void *)btm_sta_head, datalen);
	}

	if (spolicy->radios) {
		datalen = spolicy->radios * (sizeof(struct radio_policy_head) + sizeof(struct radio_policy));
		policy = (struct radio_policy *)buf;
		policy->radio_cnt = spolicy->radios;
		radio_head = policy->radio;
		SLIST_FOREACH(policy_db, &spolicy->radio_policy_head, radio_policy_entry)
		{
			memcpy(radio_head->identifier, policy_db->identifier, ETH_ALEN);
			radio_head->policy = policy_db->steer_policy;
			radio_head->ch_ultil_thres = policy_db->ch_util_thres;
			radio_head->rssi_thres = policy_db->rssi_thres;
			radio_head++;
		}
		wapp_set_info_by_msgtype(ctx, WAPP_USER_SET_RADIO_CONTROL_POLICY, NULL,
			(void *)policy, datalen);
	}
}

void wapp_set_metrics_policy_setting(struct p1905_managerd_ctx *ctx, struct metrics_policy *mpolicy)
{
	unsigned char buf[128] = {0};
	int datalen = 0;
	struct metric_policy_head *policy_head = NULL;
	struct metric_policy *policy = NULL;
	struct metric_policy_db *policy_db = NULL;

	datalen = 2 + mpolicy->radio_num * sizeof(struct metric_policy_db);
	policy = (struct metric_policy *)buf;
	policy->report_interval = mpolicy->report_interval;
	policy->policy_cnt = mpolicy->radio_num;
	policy_head = policy->policy;
	SLIST_FOREACH(policy_db, &(mpolicy->policy_head), policy_entry)
	{
		memcpy(policy_head->identifier, policy_db->identifier, ETH_ALEN);
		policy_head->rssi_thres = policy_db->rssi_thres;
		policy_head->hysteresis_margin = policy_db->hysteresis_margin;
		policy_head->ch_util_thres = policy_db->ch_util_thres;
		policy_head->sta_stats_inclusion = policy_db->sta_stats_inclusion;
		policy_head->sta_metrics_inclusion = policy_db->sta_metrics_inclusion;
		policy_head++;
	}
	wapp_set_info_by_msgtype(ctx, WAPP_USER_SET_METIRCS_POLICY, NULL, (void *)policy, datalen);

}


