/*
 * cleopatre/application/p1905_managerd/src/p1905_ap_autoconfig.c
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <errno.h>
#include <pthread.h>
#include "p1905_managerd.h"
#include "p1905_ap_autoconfig.h"
#include "cmdu_message.h"
#include "cmdu.h"
#include "multi_ap.h"
#include "_1905_lib_io.h"
#include "debug.h"
#include "eloop.h"
#include "topology.h"

#define AUTO_CONFIG_TIMEOUT_CNT 256
extern const unsigned char p1905_multicast_address[6];
void trigger_auto_config_flow(struct p1905_managerd_ctx *ctx);
void reset_radio_config_state(struct p1905_managerd_ctx *ctx);

int ap_autoconfig_init(struct p1905_managerd_ctx *ctx)
{
	if (ctx->role == AGENT) {
		/*set defalut index = -1*/
		ctx->current_autoconfig_info.radio_index = -1;
	    ctx->enrolle_state = no_ap_autoconfig;
	    ctx->current_rx_data = NULL;
	    ctx->is_authenticator_exist_in_M2 = 0;
	    ctx->is_in_encrypt_settings = 0;
	    ctx->get_config_attr_kind = 0;
	}

	ctx->last_rx_data = os_malloc(10240);
	if (!ctx->last_rx_data) {
		debug(DEBUG_ERROR, "failed to allocate last_rx_data\n");
		goto fail3;
	}
	ctx->last_rx_buf_len = 10240;
	ctx->last_rx_length = 0;

	ctx->last_tx_data = os_malloc(10240);
	if (!ctx->last_tx_data) {
		debug(DEBUG_ERROR, "failed to allocate last_tx_data\n");
		goto fail2;
	}
	ctx->last_tx_buf_len = 10240;
	ctx->last_tx_length = 0;


    ctx->is_ap_config_by_eth = 0;
    get_uuid(ctx->uuid);

	return 0;
fail2:
	os_free(ctx->last_rx_data);
fail3:
	return -1;
}

void ap_autoconfig_search(struct p1905_managerd_ctx* ctx, unsigned short mid)
{
	int i = 0;
	unsigned char multicast_address[ETH_ALEN] = {0};

	memcpy(multicast_address, p1905_multicast_address, ETH_ALEN);
	for (i = 0; i < ctx->itf_number; i++) {
		insert_cmdu_txq(multicast_address, ctx->p1905_al_mac_addr,
			e_ap_autoconfiguration_search, mid, ctx->itf[i].if_name, 0);
#ifdef SUPPORT_CMDU_RELIABLE
		cmdu_reliable_send(ctx, e_ap_autoconfiguration_search, mid, i);
#endif
	}
}

void ap_controller_search_step(void *eloop_ctx, void *timeout_ctx)
{
	struct p1905_managerd_ctx *ctx = (struct p1905_managerd_ctx*)eloop_ctx;

	multi_ap_controller_search_sm(ctx);

	common_process(ctx, ctx->rx_buf);
}

void multi_ap_controller_search_sm(struct p1905_managerd_ctx* ctx)
{
	switch(ctx->controller_search_state) {
	case bk_link_ready:
	    ctx->autoconfig_search_mid = ++ctx->mid;
		reset_send_tlv(ctx);
		ap_autoconfig_search(ctx, ctx->mid);
	    ctx->controller_search_state = wait_4_recv_controller_search_rsp;
		eloop_register_timeout(RECV_CONFIG_RSP_TIME, 0, ap_controller_search_step,
			(void *)ctx, NULL);
		debug(DEBUG_TRACE, "enrollee send ap config search to txq\n");
		break;
	case wait_4_send_controller_search:
		break;
	case wait_4_recv_controller_search_rsp:
		if(ctx->controller_search_cnt >= AUTO_CONFIG_TIMEOUT_CNT)
		{
			debug(DEBUG_OFF, "cannot find any controller!!!\n");
			ctx->controller_search_state = controller_search_idle;
			ctx->controller_search_cnt = 0;
		}
		else
		{
			/*re-send autoconfiguration search*/
			debug(DEBUG_OFF, "timeout, retry ap autoconfig search\n");
			ctx->controller_search_cnt++;
			ctx->autoconfig_search_mid = ++ctx->mid;
			reset_send_tlv(ctx);
			ap_autoconfig_search(ctx, ctx->mid);
			eloop_register_timeout(3, 0, ap_controller_search_step, (void *)ctx, NULL);
		}
		break;
	case controller_search_done:
		if(ctx->Certification == 1)
		{
			/*to notify the wapp to send LIB_GET_WSC_CONF which will trigger 1905 to start autoconfiguration */
			notify_wapp_search_controller_done(ctx);
		}
		else
		{
			_1905_notify_controller_found(ctx);
		}
		ctx->controller_search_state = controller_search_idle;
		eloop_cancel_timeout(ap_controller_search_step, (void *)ctx, NULL);
		reset_radio_config_state(ctx);
		trigger_auto_config_flow(ctx);
		break;
	default:
		break;
	}
}


void ap_autoconfig_enrolle_step(void *eloop_ctx, void *timeout_ctx)
{
	struct p1905_managerd_ctx *ctx = (struct p1905_managerd_ctx*)eloop_ctx;

	ap_autoconfig_enrolle_sm(ctx);

	common_process(ctx, ctx->rx_buf);
}

void ap_autoconfig_enrolle_sm(struct p1905_managerd_ctx *ctx)
{
	static unsigned int search_retry_count = 0, m1_retry_count = 0;
	unsigned char radio_index = 0, bss_idx = 0;

    switch(ctx->enrolle_state)
    {
        case wait_4_send_ap_autoconfig_search:
            /* if PLC is not authenticated and
             * if ctx->is_ap_config_by_eth = 1 and ETH doesn't connect
             * break!!!
             * this function will be called periodically by timer handler
             * so system will check PLC and ETH status periodically
             */
            if(!ctx->authenticated)
            {
                debug(DEBUG_ERROR, "cannot send auto config search message\n");
                break;
            }

            ctx->autoconfig_search_mid = ++ctx->mid;
			reset_send_tlv(ctx);
			ap_autoconfig_search(ctx, ctx->mid);

            ctx->enrolle_state = wait_4_recv_ap_autoconfig_resp;
			eloop_register_timeout(RECV_CONFIG_RSP_TIME, 0,
				ap_autoconfig_enrolle_step, (void *)ctx, NULL);
            break;

        case wait_4_recv_ap_autoconfig_resp:
                /* ap auto config timeout. Set state to no_ap_autoconfig
                   re-trigger ap autoconfig search process.
                 */
				if(search_retry_count < 2)
				{
					debug(DEBUG_OFF, "timeout, retry ap autoconfig search\n");
					search_retry_count++;
					ctx->autoconfig_search_mid = ++ctx->mid;
					reset_send_tlv(ctx);
					ap_autoconfig_search(ctx, ctx->mid);
					eloop_register_timeout(RECV_CONFIG_RSP_TIME, 0,
						ap_autoconfig_enrolle_step, (void *)ctx, NULL);
				}
				else
				{
					debug(DEBUG_OFF, "cannot find any controller!!!\n");
					ctx->enrolle_state = no_ap_autoconfig;
					auto_configuration_done(ctx);
					search_retry_count = 0;
				}
            break;
		case wait_4_send_m1:
			debug(DEBUG_OFF, "send WSC M1 to %02x:%02x:%02x:%02x:%02x:%02x\n", PRINT_MAC(ctx->cinfo.almac));

			insert_cmdu_txq(ctx->cinfo.almac, ctx->p1905_al_mac_addr,
				e_ap_autoconfiguration_wsc_m1, ++ctx->mid,
				ctx->itf[ctx->cinfo.recv_ifid].if_name, 0);

	        ctx->enrolle_state = wait_4_recv_m2;
			os_memset(&ctx->ap_config_data, 0, sizeof(WSC_CONFIG));
			eloop_cancel_timeout(ap_autoconfig_enrolle_step, (void *)ctx, NULL);
			eloop_register_timeout(RECV_WSC_M2_TIME, 0, ap_autoconfig_enrolle_step,
				(void *)ctx, NULL);
			break;
        case wait_4_recv_m2:
            /*check timeout*/
            /*if timeout happen, need to free ctx->ap_config_data*/
			search_retry_count = 0;

			if (m1_retry_count < M1_RETRY_CNT) {
				ctx->enrolle_state = wait_4_send_m1;
				debug(DEBUG_OFF, "timeout, retry m1\n");
				m1_retry_count++;
				eloop_register_timeout(0, 0, ap_autoconfig_enrolle_step, (void *)ctx, NULL);
			} else {
				debug(DEBUG_OFF, "timeout, stop retry m1\n");
				ctx->enrolle_state = no_ap_autoconfig;
				m1_retry_count = 0;
				auto_configuration_done(ctx);
			}

            break;

        case wait_4_set_config:
		{
			search_retry_count = 0;
			m1_retry_count = 0;
        	unsigned char map_vendor_extension = 0;
			int i = 0;

			for(i = 0; i < ctx->current_autoconfig_info.config_number; i++)
			{
				map_vendor_extension |= ctx->current_autoconfig_info.config_data[i].map_vendor_extension;
			}
			/*MAP controller let agent tear down*/
			if (map_vendor_extension & BIT_TEAR_DOWN) {
				if (ctx->current_autoconfig_info.radio_index != -1) {
					radio_index = (unsigned char)ctx->current_autoconfig_info.radio_index;
					debug(DEBUG_OFF, "current radio(%d) will tear down\n", radio_index);
					ctx->rinfo[radio_index].teared_down = 1;
					for (bss_idx = 0; bss_idx < ctx->rinfo[radio_index].bss_number; bss_idx++) {
						ctx->rinfo[radio_index].bss[bss_idx].config_status = 0;
					}
					delete_exist_operational_bss(ctx, ctx->rinfo[radio_index].identifier);
					/*to do tear down this radio*/
					if(ctx->Certification == 1)
					{
						wapp_set_info_by_msgtype(ctx, WAPP_USER_SET_RADIO_TEARED_DOWN, NULL,
							(void *)ctx->rinfo[radio_index].identifier, ETH_ALEN);
					}
					else
					{
						_1905_set_radio_tear_down(ctx, ctx->rinfo[radio_index].identifier);
					}
				} else {
					debug(DEBUG_ERROR, "radio_index error == -1!!!\n");
				}
			} else if (wifi_utils_success != set_wsc_config((void *)ctx)) {
                debug(DEBUG_ERROR, "set wsc config error\n");
            }

            ctx->enrolle_state = no_ap_autoconfig;
			if(ctx->Certification == 1)
			{
				radio_index = ctx->current_autoconfig_info.radio_index;
				if(radio_index <= MAX_RADIO_NUM - 1 && ctx->rinfo[radio_index].teared_down == 0)
					wapp_get_ap_capinfo(ctx, radio_index);
			}
			auto_configuration_done(ctx);
			trigger_auto_config_flow(ctx);
        }
            break;
		default:
			break;
    }
}

void ap_auto_config_renew_start(void *pctx)
{

}

int pop_node_from_stack(struct p1905_managerd_ctx *ctx)
{
	leaf_info *leaf_top = NULL;

	if(stack_empty(ctx->topo_stack)) {
		debug(DEBUG_ERROR, "controller_renew_bss: topo stack empty\n");
		ctx->trigger_renew = 0;
		return -1;
	}
	get_top(&ctx->topo_stack, &leaf_top);

	debug(DEBUG_OFF, "pop_node_from_stack, pop out_mac(%02x:%02x:%02x:%02x:%02x:%02x), radio_cap = %02x\n",
			PRINT_MAC(leaf_top->al_mac), leaf_top->radio_cap);

	if (!os_memcmp(ctx->p1905_al_mac_addr, leaf_top->al_mac, ETH_ALEN)) {
		debug(DEBUG_OFF, "do not renew to controller almac(%02x:%02x:%02x:%02x:%02x:%02x)\n",
			PRINT_MAC(leaf_top->al_mac));
		ctx->renew_state = wait_4_apply_local;
		eloop_register_timeout(0, 0, controller_renew_bss_step, (void *)ctx, NULL);
		return 0;
	}

	if (leaf_top->band_cap & BAND_2G_CAP) {
		leaf_top->cur_renew_band = 0;
	} else if (leaf_top->band_cap & (BAND_5GL_CAP | BAND_5GH_CAP | BAND_5G_CAP)) {
		leaf_top->cur_renew_band = 1;
	} else {
		debug(DEBUG_ERROR, "error band cap(%02x)\n", leaf_top->band_cap);
		ctx->trigger_renew = 0;
		return -1;
	}

	leaf_top->renew_retry_cnt = 3;
	ctx->renew_state = wait_4_send_renew;
	eloop_register_timeout(0, 0, controller_renew_bss_step, (void *)ctx, NULL);

	return 0;
}

int controller_send_renew(struct p1905_managerd_ctx *ctx)
{
	struct topology_response_db *rpdb = NULL;
	leaf_info *leaf_top = NULL;
	int ret = 0;

	ret = get_top(&ctx->topo_stack, &leaf_top);
	if (ret < 0) {
		debug(DEBUG_ERROR, "BUG here!!!! get top node from stack error\n");
		ctx->trigger_renew = 0;
		return -1;
	}

	debug(DEBUG_OFF, "controller_send_renew ++, renew band: %s\n",
		(leaf_top->cur_renew_band == 0) ? "2G" : "5G");

	rpdb = lookup_tprdb_by_almac(ctx, leaf_top->al_mac);
	if (!rpdb) {
		debug(DEBUG_ERROR, "BUG here!!!! rpdb almac(%02x:%02x:%02x:%02x:%02x:%02x) not exist\n",
			PRINT_MAC(leaf_top->al_mac));
		ctx->trigger_renew = 0;
		return -1;
	}

	if (fill_send_tlv(ctx, &leaf_top->cur_renew_band, 1) < 0) {
		ctx->trigger_renew = 0;
		return -1;
	}

	insert_cmdu_txq(leaf_top->al_mac, ctx->p1905_al_mac_addr,
		e_ap_autoconfiguration_renew, ++ctx->mid,
		(rpdb->recv_ifid != -1) ? ctx->itf[rpdb->recv_ifid].if_name : ctx->br_name, 0);

	ctx->renew_state = wait_4_recv_m1;
	eloop_register_timeout(RECV_WSC_M1_TIME, 0, controller_renew_bss_step, (void *)ctx, NULL);

	return 0;

}

void controller_renew_bss_step(void *eloop_ctx, void *timeout_ctx)
{
	struct p1905_managerd_ctx *ctx = (struct p1905_managerd_ctx*)eloop_ctx;

	controller_renew_bss_sm(ctx);

	common_process(ctx, ctx->rx_buf);
}


void controller_renew_bss_sm(struct p1905_managerd_ctx *ctx)
{
	leaf_info *leaf_top = NULL;
	int ret = 0;

	switch(ctx->renew_state)
	{
		case wait_4_dump_topo:
		{
			empty_stack(&ctx->topo_stack);
			/*travel topology tree and dump the topo*/
			topology_tree_travel_preorder(ctx, ctx->root_leaf);

			ctx->renew_state = wait_4_pop_node;
			eloop_register_timeout(0, 0, controller_renew_bss_step, (void *)ctx, NULL);
		}
		break;

		case wait_4_pop_node:
		{
			pop_node_from_stack(ctx);
		}
		break;

		case wait_4_send_renew:
		{
			controller_send_renew(ctx);
		}
		break;

		case wait_4_recv_m1:
		{
			ret = get_top(&ctx->topo_stack, &leaf_top);
			if (ret < 0) {
				debug(DEBUG_ERROR, "BUG here!!!! get top node from stack error\n");
				ctx->trigger_renew = 0;
				return;
			}

			/*send renew message, wait for m1 message timeout*/
			debug(DEBUG_OFF, "send renew but get M1 timeout, cur_renew_band: %02x\n",
				leaf_top->cur_renew_band);
			leaf_top->renew_retry_cnt--;
			if (leaf_top->cur_renew_band == 0) {
				/*renew 2g, but fail to get M1*/
				if (leaf_top->renew_retry_cnt <= 0) {
					//renew next band(5g)
					leaf_top->fin_renew_radio |= RADIO_2G_CAP;
					leaf_top->cur_renew_band = 1;
					leaf_top->renew_retry_cnt = 3;
				}
				ctx->renew_state = wait_4_send_renew;
			} else {
				//2g renew done(success or fail),  send renew message for 5g, but get M1 fail
				if (leaf_top->renew_retry_cnt <= 0) {
					//renew next agent
					pop_node(&ctx->topo_stack);
					ctx->renew_state = wait_4_pop_node;
				} else {
					ctx->renew_state = wait_4_send_renew;
				}
			}
			eloop_register_timeout(0, 0, controller_renew_bss_step, (void *)ctx, NULL);
		}
		break;

		case wait_4_recv_m2_ack:
		{
			/*send m2 message, wait for ack timeout*/
			ret = get_top(&ctx->topo_stack, &leaf_top);
			if (ret < 0) {
				debug(DEBUG_ERROR, "BUG here!!!! get top node from stack error\n");
				ctx->trigger_renew = 0;
				return;
			}
			debug(DEBUG_OFF, "send M2 but get ACK timeout, cur_renew_radio: %02x\n",
				leaf_top->cur_renew_radio);
			leaf_top->fin_renew_radio |= leaf_top->cur_renew_radio;
			if (leaf_top->cur_renew_radio == RADIO_2G_CAP) {
				if (leaf_top->band_cap & (BAND_5GL_CAP | BAND_5GH_CAP | BAND_5G_CAP)) {
					leaf_top->renew_retry_cnt = 3;
					leaf_top->cur_renew_band = 1;
					ctx->renew_state = wait_4_send_renew;
				} else {
					pop_node(&ctx->topo_stack);
					ctx->renew_state = wait_4_pop_node;
				}
				eloop_register_timeout(0, 0, controller_renew_bss_step, (void *)ctx, NULL);
			} else if (leaf_top->cur_renew_radio == RADIO_5GL_CAP || leaf_top->cur_renew_radio == RADIO_5GH_CAP) {
				pop_node(&ctx->topo_stack);
				ctx->renew_state = wait_4_pop_node;
				eloop_register_timeout(0, 0, controller_renew_bss_step, (void *)ctx, NULL);
			} else if (leaf_top->cur_renew_radio == RADIO_5G_CAP){
				pop_node(&ctx->topo_stack);
				ctx->renew_state = wait_4_pop_node;
				eloop_register_timeout(0, 0, controller_renew_bss_step, (void *)ctx, NULL);
			} else {
				debug(DEBUG_ERROR, "error radio(%02x) for %02x:%02x:%02x:%02x:%02x:%02x\n",
					leaf_top->cur_renew_radio, PRINT_MAC(leaf_top->al_mac));
			}
		}
		break;
		case wait_4_apply_local:
		{
			int i = 0;
			debug(DEBUG_ERROR, "apply bss config locally\n")
			for (i = 0; i < ctx->radio_number; i++) {
				_1905_update_bss_info_per_radio(ctx, &ctx->rinfo[i]);
			}
			ctx->trigger_renew = 0;
		}
		break;

		default:
			break;

	}
}


void agent_apply_new_config(void *eloop_ctx, void *timeout_ctx) {
	struct p1905_managerd_ctx *ctx = (struct p1905_managerd_ctx*)eloop_ctx;
	debug(DEBUG_ERROR, "agent_apply_new_config ++\n");

	ctx->is_renew_ongoing = 0;
	flash_wsc_config(ctx);
}

void reset_radio_config_state(struct p1905_managerd_ctx *ctx)
{
	int i = 0;

	if (ctx->role == CONTROLLER)
		return;

	for (i = 0; i < ctx->radio_number; i++)
	{
		ctx->rinfo[i].config_status = MAP_CONF_UNCONF;
	}
	debug(DEBUG_ERROR, "reset config status done (total radios:%d)\n", i);
}

void trigger_auto_config_flow(struct p1905_managerd_ctx *ctx)
{
	int i = 0;
	int ret =0;
	struct radio_info* rinfo = NULL;

	if(ctx == NULL)
		return;
	if (ctx->role == CONTROLLER)
		return;

	for (i = 0; i < ctx->radio_number; i++)
	{
		if(ctx->rinfo[i].config_status == MAP_CONF_UNCONF)
		{
			rinfo = &(ctx->rinfo[i]);
			break;
		}
	}

	if(!rinfo)
	{
		debug(DEBUG_ERROR, "trigger radio auto config done\n");
		return;
	}

	ctx->authenticated = 1;

	ret= set_radio_autoconf_trriger(ctx, rinfo->identifier, 1);

	if (ret == -1)
	{
		debug(DEBUG_ERROR, "drop this auto config (radio: %d)\n", i);
		return;
	}
	else if (ret == -2)
	{
		debug(DEBUG_ERROR, "should trigger next radio (cur radio: %d)\n", i);
		ctx->rinfo[i].config_status = MAP_CONF_CONFED;
		trigger_auto_config_flow(ctx);
	}
	else if (ret == 0)
	{
		triger_autoconfiguration(ctx);
		debug(DEBUG_ERROR, "trigger auto config flow (radio: %d)\n", i);
	}

}

