#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <linux/netlink.h>
#include <linux/socket.h>
#include <sys/types.h>
#include <unistd.h>
#include <net/if.h>

#include "os.h"
#include "mapfilter_if.h"

static int netlink_sock = 0;
static int netlink_pid = 0;

unsigned char cmd_buf[1024];

int mapfilter_netlink_init(unsigned int pid)
{
    int sock;
    struct sockaddr_nl addr;

    sock = socket(AF_NETLINK, SOCK_RAW, MAP_NETLINK);
    if (sock < 0) {
        printf("sock < 0.\n");
        return -1;
    }

    memset((void *) &addr, 0, sizeof(addr));
    addr.nl_family = AF_NETLINK;
    addr.nl_pid = pid;
	addr.nl_groups = 0;
    /* This doesn't work for some reason. See the setsockopt() below. */
    /* addr.nl_groups = MYMGRP; */

    if (bind(sock, (struct sockaddr *) &addr, sizeof(addr)) < 0) {
        printf("bind < 0.\n");
	    close(sock);
        return -1;
    }

	netlink_sock = sock;
	netlink_pid = pid;
    return sock;
}

int mapfilter_netlink_deinit(int sock)
{
	close(sock);
	
	return 0;
}

static int mapfilter_netlink_msg_send(const unsigned char *message, int len, unsigned int dst_group)
{
	struct nlmsghdr *nlh = NULL;
	struct sockaddr_nl dest_addr;
	struct iovec iov;
	struct msghdr msg;

	if(!message ) {
		return -1;
	}

	//create message
	nlh = (struct nlmsghdr *)os_malloc(NLMSG_SPACE(len));
	if (!nlh) {
		printf("allocate nlmsghdr fail\n");
		return -1;
	}
	nlh->nlmsg_len = NLMSG_SPACE(len);
	nlh->nlmsg_pid = netlink_pid;
	nlh->nlmsg_flags = 0;
	os_memcpy(NLMSG_DATA(nlh), message, len);

	iov.iov_base = (void *)nlh;
	iov.iov_len = nlh->nlmsg_len;
	os_memset(&dest_addr, 0, sizeof(struct sockaddr_nl));
	dest_addr.nl_family = AF_NETLINK;
	dest_addr.nl_pid = 0;
	dest_addr.nl_groups = dst_group;

	os_memset(&msg, 0, sizeof(struct msghdr));
	msg.msg_name = (void *)&dest_addr;
	msg.msg_namelen = sizeof(struct sockaddr_nl);
	msg.msg_iov = &iov;
	msg.msg_iovlen = 1;

	//send message
	if (sendmsg(netlink_sock, &msg, 0) < 0) {
		printf("netlink msg send fail\n");
		os_free(nlh);
		return -3;
	}

	os_free(nlh);
	return 0;
}

int mapfilter_set_all_interface(struct local_itfs *itf)
{
	struct map_netlink_message *msg = (struct map_netlink_message*)cmd_buf;
	int len = sizeof(struct local_itfs) + itf->num * sizeof(struct local_interface);
	int ret = 0;

	msg->type = UPDATE_MAP_NET_DEVICE;
	msg->len = len;
	os_memcpy(msg->event, (unsigned char*)itf, len);
	
	ret = mapfilter_netlink_msg_send(cmd_buf, sizeof(struct map_netlink_message) + len, 0);
	return ret;
}

int mapfilter_set_primary_interface(struct local_interface *itf, unsigned char primary)
{
	struct map_netlink_message *msg = (struct map_netlink_message*)cmd_buf;
	struct primary_itf_setting *setting = (struct primary_itf_setting*)msg->event;
	int len = sizeof(struct primary_itf_setting);
	int ret = 0;
	
	msg->type = SET_PRIMARY_INTERFACE;
	os_memcpy(&setting->inf, itf, sizeof(struct local_interface));
	setting->primary = primary;
	msg->len = len;
	
	ret = mapfilter_netlink_msg_send(cmd_buf, sizeof(struct map_netlink_message) + len, 0);
	return ret;
}

int mapfilter_set_uplink_path(struct local_interface *in, struct local_interface *out)
{
	struct map_netlink_message *msg = (struct map_netlink_message*)cmd_buf;
	struct up_link_path_setting *setting = (struct up_link_path_setting*)msg->event;
	int len = 0, ret = 0;
	
	msg->type = SET_UPLINK_PATH_ENTRY;
	os_memcpy(&setting->in, in, sizeof(struct local_interface));
	os_memcpy(&setting->out, out, sizeof(struct local_interface));
	len = sizeof(struct up_link_path_setting);
	msg->len = len;

	ret = mapfilter_netlink_msg_send(cmd_buf, sizeof(struct map_netlink_message) + len, 0);
	return ret;
}

int mapfilter_dump_debug_info()
{
	struct map_netlink_message *msg = (struct map_netlink_message*)cmd_buf;

	int ret = 0;
	
	msg->type = DUMP_DEBUG_INFO;

	ret = mapfilter_netlink_msg_send(cmd_buf, sizeof(struct map_netlink_message), 0);
	return ret;
}
#ifdef MAP_R2
int mapfilter_set_ts_default_8021q(unsigned short primary_vid, unsigned char default_pcp)
{
	struct map_netlink_message *msg = (struct map_netlink_message*)cmd_buf;
	struct ts_default_8021q *setting = (struct ts_default_8021q*)msg->event;
	int len = 0, ret = 0;
	
	msg->type = SET_TRAFFIC_SEPARATION_DEFAULT_8021Q;
	setting->primary_vid = primary_vid;
	setting->default_pcp = default_pcp;
	len = sizeof(struct ts_default_8021q);
	msg->len = len;

	ret = mapfilter_netlink_msg_send(cmd_buf, sizeof(struct map_netlink_message) + len, 0);
	return ret;
}

int mapfilter_set_ts_policy(unsigned char num, struct ssid_2_vid_mapping *mapping)
{
	struct map_netlink_message *msg = (struct map_netlink_message*)cmd_buf;
	struct ts_policy *setting = (struct ts_policy*)msg->event;
	int len = 0, ret = 0;
	
	msg->type = SET_TRAFFIC_SEPARATION_POLICY;
	setting->num = num;

	if (mapping)
		os_memcpy(setting->ssid_2_vid, mapping, num * sizeof(struct ssid_2_vid_mapping));
	
	len = sizeof(struct ts_policy) + num * sizeof(struct ssid_2_vid_mapping);
	msg->len = len;

	ret = mapfilter_netlink_msg_send(cmd_buf, sizeof(struct map_netlink_message) + len, 0);
	return ret;
}

#endif



