/*
 * cleopatre/application/p1905_managerd/src/lldp.c
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#include <stdio.h>
#include <string.h>
#include <net/if.h>
#include <syslog.h>
#include <assert.h>
#include <linux/if_ether.h>
#include <asm/byteorder.h>
#include <sys/socket.h>
#include <errno.h>
#include <linux/if_packet.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "lldp.h"
#include "cmdu.h"
#include "byteorder.h"
#include "debug.h"


extern void delete_lldp_queue_all();
extern void init_lldp_rx_queue();


int lldpdu_init(struct p1905_managerd_ctx *ctx)
{
    struct ifreq ifr;

    /*Create a receive connection of lldpdu on bridge interface*/
    if(0 > (ctx->sock_lldp = socket(AF_PACKET, SOCK_RAW, ETH_P_LLDP)))
    {
        debug(DEBUG_ERROR, "cannot open lldpdu socket on %s (%s)", ctx->br_name,
               strerror(errno));
        return -1;
    }

    /*Prepare lldpdu socket interface index*/
	strcpy(ifr.ifr_name, (char*)ctx->br_name);
    if(-1 == (ioctl(ctx->sock_lldp, SIOCGIFINDEX, &ifr)))
    {
        debug(DEBUG_ERROR, "cannot get interface %s index (%s) for lldpdu",
               ctx->br_name, strerror(errno));
        close(ctx->sock_lldp);
        return -1;
    }

    ctx->lldp_sll.sll_family = AF_PACKET;
    ctx->lldp_sll.sll_ifindex = ifr.ifr_ifindex;
    ctx->lldp_sll.sll_protocol = cpu2be16(ETH_P_LLDP);

    /*Bind lldpdu socket to this interface*/
    if(-1 == (bind(ctx->sock_lldp, (struct sockaddr *)&ctx->lldp_sll,
              sizeof(struct sockaddr_ll))))
    {
        debug(DEBUG_ERROR, "cannot bind raw socket to interface %s (%s)",
               ctx->br_name, strerror(errno));
        close(ctx->sock_lldp);
        return -1;
    }

    /*init lldp rx queue*/
    init_lldp_rx_queue();

    return 0;
}

void lldpdu_uninit(struct p1905_managerd_ctx *ctx)
{
    delete_lldp_queue_all();
    close(ctx->sock_lldp);
}

int send_802_1_bridge_discovery_msg(struct p1905_managerd_ctx *ctx,
                    unsigned char *dmac, unsigned char *smac,
                    unsigned char *buffer, int if_index)
{
    struct ethhdr *eth_hdr;
    unsigned char *temp_buf;
    int total_len;

    temp_buf = buffer;

    eth_hdr = (struct ethhdr*)buffer;
    memcpy(eth_hdr->h_dest, dmac, ETH_ALEN);
    memcpy(eth_hdr->h_source, smac, ETH_ALEN);
    eth_hdr->h_proto = cpu2be16(ETH_P_LLDP);

    /*shift to start position of lldpdu */
    temp_buf += ETH_HLEN;

    total_len =
    create_802_1_bridge_discovery_message(temp_buf,ctx->p1905_al_mac_addr,smac);

    /*total length = lldpdu length + ether header length*/
    total_len += ETH_HLEN;

    total_len = send(ctx->sock_inf_recv_1905[if_index], buffer, total_len, 0);
    if(0 > total_len)
    {
		if (errno == ENETDOWN) {
			debug(DEBUG_ERROR, "error reason(%s)\n", strerror(errno));
			return 0;
		}
        return -1;
    }

    return total_len;
}

int receive_802_1_bridge_discovery_msg(struct p1905_managerd_ctx *ctx,
                            unsigned char *buf, int len)
{
    len = recv(ctx->sock_lldp, buf, len, 0);

    if(0 >= len)
    {
        debug(DEBUG_WARN, "lldp receive failed on %s (%s)", ctx->br_name,
               strerror(errno));
        return -1;
    }
    return len;
}
