#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <errno.h>
#include <assert.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <sys/sem.h>
#include <stddef.h>
#include <unistd.h>
#include "p1905_managerd.h"
#include "cmdu_tlv.h"
#include "cmdu_message.h"
#include "multi_ap.h"
#include "debug.h"



int _1905_write_mid(char* name, unsigned short mid)
{
	FILE *f;
	int fd;
	f = fopen(name, "w");
	if (f == NULL)
	{
		debug(DEBUG_ERROR, "Failed to open '%s' for writing\n", name);
		return -1;
	}
	fprintf(f, "mid 0x%04x\n", mid);
	fd = fileno(f);
	fsync(fd);
	fclose(f);
	return 0;
}

int _1905_read_set_config(struct p1905_managerd_ctx *ctx, char *name,
	struct set_config_bss_info bss_info[], unsigned char max_bss_num,
	unsigned char *config_bss_num)
{
	FILE* f;
	int index, resv1, resv2, i, j;
	unsigned int mac_int[6] = {0};
	unsigned char mac[6] = {0};
	char op_class[4] = {0};
	unsigned char ssid[33] = {0}, ssid_tlv[33];
	int authmode = 0, encrytype = 0;
	int value = 0, pcp = 0;
	unsigned char key[65] = {0};
	char content[4096] = {0};
	char *pos1 = NULL, *pos2 = NULL, *end_line = NULL;
	signed char ch = 0, sch = 0;
	unsigned char hidden_ssid = 0;
	//unsigned char hidden_ssid_exist = 0;
	unsigned int pvid = 0, vid = 0;
	unsigned char fh_bss_unhidden = 0;
	unsigned char op_8x = 0, op_11x = 0, op_12x = 0;
	unsigned int ssid_len = 0;
	char backslash = 0x5C;
	char space = 0x20;
	char SUB = 0x1A;


	f = fopen(name, "r");
	if (f == NULL) {
		debug(DEBUG_ERROR, "open file %s fail\n", name);
		return -1;
	}

	for (i = 0; i < max_bss_num; i++) {
		memset(&bss_info[i], 0, sizeof(struct set_config_bss_info));
	}

	i = 0;
	do {
    		ch = fgetc(f);
		/* If ssid is a space, need add \ as ESC infront of it in wts file. As space is regard as
		* a separator. If ssid is a \, need add \ as ESC in front of it. when parsing wts file,
		"\space"need remove \ and replace space to SUB. "\\"need remove \*/
		if (ch == backslash) {
			sch = fgetc(f);
			if (sch == space) {
				ch = SUB;
			} else if (sch == backslash) {
				ch = sch;
			} else {
				content[i++] = ch;
				ch = sch;
			}
		}
		content[i++] = ch;
		debugbyte(DEBUG_TRACE, "%c", ch);
	}while (EOF != ch);
	debugbyte(DEBUG_TRACE, "\n");

	i = 0;
	pos1 = content;
	while (1) {
		memset(ssid, 0, sizeof(ssid));
		pvid = 0;
		pcp = 0;
		vid = 0;
		hidden_ssid = 0;

		/*index*/
		pos2 = strchr(pos1, ',');
		if (pos2 == NULL) {
			debug(DEBUG_TRACE, "index not found\n");
			break;
		}
		*pos2 = '\0';
		sscanf(pos1, "%d", &index);
		pos2++;
		pos1 = pos2;

		/*mac*/
		pos2 = strchr(pos1, ' ');
		if (pos2 == NULL) {
			debug(DEBUG_ERROR, "mac not found\n");
			break;
		}
		*pos2 = '\0';
		sscanf(pos1, "%02x:%02x:%02x:%02x:%02x:%02x", mac_int,
			(mac_int + 1), (mac_int + 2), (mac_int + 3),
			(mac_int + 4), (mac_int + 5));
		for (j = 0; j < 6; j++)
			mac[j] = (unsigned char)mac_int[j];

		pos2++;
		pos1 = pos2;

		/*opclass*/
		pos2 = strchr(pos1, ' ');
		if (pos2 == NULL) {
			debug(DEBUG_ERROR, "opclass not found\n");
			break;
		}
		*pos2 = '\0';

		sscanf(pos1, "%s", op_class);
		debug(DEBUG_TRACE, "opclass %s\n", op_class);

		if (0 == memcmp(op_class, "8", 1)) {
			op_8x ++;
		}
		else if (0 == memcmp(op_class, "11", 2)) {
			op_11x ++;
		}
		else if (0 == memcmp(op_class, "12", 2)) {
			op_12x ++;
		}

		pos2++;
		pos1 = pos2;

		/*ssid*/
		pos2 = strchr(pos1, ' ');
		if (pos2 == NULL) {
			debug(DEBUG_ERROR, "ssid not found\n");
			break;
		}
		*pos2 = '\0';
		sscanf(pos1, "%33s", ssid);
		ssid[32] = '\0';
		/*replace SUB to space*/
		for (j = 0; j < 32; j++) {
			if (ssid[j] == SUB)
				ssid[j] = space;
		}
		pos2++;
		pos1 = pos2;

		/*authmode*/
		pos2 = strchr(pos1, ' ');
		if (pos2 == NULL) {
			debug(DEBUG_ERROR, "authmode not found\n");
			break;
		}
		*pos2 = '\0';
		sscanf(pos1, "0x%04x", &authmode);
		pos2++;
		pos1 = pos2;

		/*encrytype*/
		pos2 = strchr(pos1, ' ');
		if (pos2 == NULL) {
			debug(DEBUG_ERROR, "encrytype not found\n");
			break;
		}
		*pos2 = '\0';
		sscanf(pos1, "0x%04x", &encrytype);
		pos2++;
		pos1 = pos2;

		/*key*/
		pos2 = strchr(pos1, ' ');
		if (pos2 == NULL) {
			debug(DEBUG_ERROR, "key not found\n");
			break;
		}
		*pos2 = '\0';
		sscanf(pos1, "%s", key);
		pos2++;
		pos1 = pos2;

		/*resv1*/
		pos2 = strchr(pos1, ' ');
		if (pos2 == NULL) {
			debug(DEBUG_ERROR, "resv1 not found\n");
			break;
		}
		*pos2 = '\0';
		sscanf(pos1, "%d", &resv1);
		pos2++;
		pos1 = pos2;

		/*resv2*/
		//*pos2 and pos2 point to bh;
		sscanf(pos1, "%d", &resv2);

		end_line = strchr(pos1, '\n');
		if (!end_line)
			break;

		// no ts, no hiddden-ssid, to next line
		if (end_line - pos2 == 1) {
			pos2 += 2;
			pos1 = pos2;
		}

		/* default vlan policy 0xB5*/
		pos2 = strstr(pos1, "B5");
		if (pos2 == NULL || pos2 >= end_line) {
			debug(DEBUG_ERROR, "default vlan tlv not found\n");
		} else {
			pos1 = pos2;

			/* move to tlv length */
			pos2 = strstr(pos1, "0x");
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "default vlan tlv len not found\n");
				break;
			}
			pos2 += 2;
			pos1 = pos2;
			sscanf(pos1, "%04x", &value);

			/* move to vlan */
			pos2 = strstr(pos1, "0x");
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "default vlan not found\n");
				break;
			}
			pos2 += 2;
			pos1 = pos2;
			sscanf(pos1, "%04x", &pvid);

			/* move to pcp */
			pos2 = strstr(pos1, "0x");
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "default pcp not found\n");
				break;
			}
			pos2 += 2;
			pos1 = pos2;
			sscanf(pos1, "%02x", &pcp);
		}

		/* traffic separation policy */
		pos2 = strstr(pos1, "B6");
		if (pos2 == NULL || pos2 >= end_line) {
			debug(DEBUG_ERROR, "traffic seperation tlv not found\n");
		} else {
			pos1 = pos2;

			/* move to tlv length */
			pos2 = strstr(pos1, "0x");
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "traffic separation length not found\n");
				break;
			}
			pos2 += 2;
			pos1 = pos2;
			sscanf(pos1, "%04x", &value);

			/* move to num ssid */
			pos2 = strstr(pos1, "0x");
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "num of ssid not found\n");
				break;
			}
			pos2 += 2;
			pos1 = pos2;
			sscanf(pos1, "%02x", &value);

			/* move to ssid len */
			pos2 = strstr(pos1, "0x");
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "ssid len not found\n");
				break;
			}
			pos2 += 2;
			pos1 = pos2;
			sscanf(pos1, "%02x", &ssid_len);

			/* ssid */
			pos2 = strchr(pos1, ' ');
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "ssid not found\n");
				break;
			}
			pos2 ++;
			pos1 = pos2;

			sscanf(pos1, "%s", ssid_tlv);
			debug(DEBUG_ERROR, "ssid tlv  %s\n",ssid_tlv);

			/* move to vlan */
			pos2 = strstr(pos1, "0x");
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "vlan not found\n");
				break;
			}
			pos2 += 2;
			pos1 = pos2;
			sscanf(pos1, "%04x", &vid);

			/* end of vlan */
			pos2 = strchr(pos1, '\n');
			if (!pos2)
				break;
			else
				pos2 ++;
			pos1 = pos2;
		}

		pos2 = strstr(pos1, "hidden-");
		if (pos2 == NULL || pos2 >= end_line) {
			debug(DEBUG_TRACE, "no hidden SSID exist\n");
		} else {
			pos1 = pos2;
			/*hidden ssid*/
			pos2 = strchr(pos1, '\n');
			if (pos2 == NULL) {
				debug(DEBUG_ERROR, "hidden ssid not found\n");
				break;
			}
			*pos2 = '\0';
			if (sscanf(pos1, "hidden-%c", &hidden_ssid) == 1) {
				pos2++;
				pos1 = pos2;
			} else {
				debug(DEBUG_ERROR, "wrong format hidden ssid\n");
				break;
			}
		}
		bss_info[i].authmode = authmode;
		bss_info[i].encryptype = encrytype;
		memcpy(bss_info[i].mac, mac, 6);
		memcpy(bss_info[i].key, key, sizeof(key));
		memcpy(bss_info[i].oper_class, op_class, sizeof(op_class));
		memcpy(bss_info[i].ssid, ssid, sizeof(ssid));
		bss_info[i].wfa_vendor_extension |= (resv1 & 0x01) << 6;
		bss_info[i].wfa_vendor_extension |= (resv2 & 0x01) << 5;
		bss_info[i].pvid = pvid;
		bss_info[i].pcp = pcp;
		bss_info[i].vid = vid;
		bss_info[i].ssid_len = ssid_len;
		if (hidden_ssid == 'Y')
			bss_info[i].hidden_ssid = 1;
		else if (hidden_ssid == 'N')
			bss_info[i].hidden_ssid = 0;
		else
			bss_info[i].hidden_ssid = 0;
		debug(DEBUG_OFF, "set bss index=%d, mac=%02x:%02x:%02x:%02x:%02x:%02x,"
			" opclass=%s, ssid=%s, ssid_len %d, authmode=%04x, encrytype=%04x, key=%s, "
			"bh_bss=%s, fh_bss=%s pvid %d, pcp %d, vlan %d hidden_ssid=%d\n",
			index, PRINT_MAC(mac), op_class, ssid,ssid_len,  authmode, encrytype, key,
			bss_info[i].wfa_vendor_extension & BIT_BH_BSS ? "1" : "0",
			bss_info[i].wfa_vendor_extension & BIT_FH_BSS ? "1" : "0",
			bss_info[i].pvid, bss_info[i].pcp, bss_info[i].vid,
			bss_info[i].hidden_ssid);
		i++;
		if (i >= max_bss_num) {
			debug(DEBUG_ERROR, "too much bss wireless setting info\n");
			i--;
			break;
		}
	}

	*config_bss_num = i;
	debug(DEBUG_OFF, "config_bss_num=%d\n", *config_bss_num);
	fclose(f);

	if (0 == op_8x) {
		debug(DEBUG_OFF, RED("!!!2G Band BSS Configuration is missing!!!\n"));
	}
	if (0 == op_11x) {
		debug(DEBUG_OFF, RED("!!!5G Low Band BSS Configuration is missing!!!\n"));
	}
	if (0 == op_12x) {
		debug(DEBUG_OFF, RED("!!!5G High Band BSS Configuration is missing!!!\n"));
	}

	fh_bss_unhidden = 0;
	for (i = 0; i < *config_bss_num; i++) {
		if ((bss_info[i].oper_class[0] == '8') &&
			(bss_info[i].wfa_vendor_extension & BIT_FH_BSS) &&
			(bss_info[i].hidden_ssid == 0)) {
			fh_bss_unhidden = 1;
			break;
		}
	}
	if (fh_bss_unhidden == 0) {
		debug(DEBUG_OFF, "all fronthaul bss of radio 24G is hidden! wps may fail!\n");
	}

	fh_bss_unhidden = 0;
	for (i = 0; i < *config_bss_num; i++) {
		if ((bss_info[i].oper_class[1] == '1') &&
			(bss_info[i].wfa_vendor_extension & BIT_FH_BSS) &&
			(bss_info[i].hidden_ssid == 0)) {
			fh_bss_unhidden = 1;
			break;
		}
	}
	if (fh_bss_unhidden == 0) {
		debug(DEBUG_ERROR, "all fronthaul bss of radio 5GL is hidden! wps may fail!\n");
	}

	fh_bss_unhidden = 0;
	for (i = 0; i < *config_bss_num; i++) {
		if ((bss_info[i].oper_class[1] == '2') &&
			(bss_info[i].wfa_vendor_extension & BIT_FH_BSS) &&
			(bss_info[i].hidden_ssid == 0)) {
			fh_bss_unhidden = 1;
			break;
		}
	}
	if (fh_bss_unhidden == 0) {
		debug(DEBUG_ERROR, "all fronthaul bss of radio 5GH is hidden! wps may fail!\n");
	}
	return 0;
}

char* get_raw_data_end(char *content)
{
	char flag_ch[5] = {'_', 0x0a, 0x0d, '\0', ' '};
	int i = 0;
	char* temp = NULL;
	char* temp_min = NULL;

	for(i = 0; i < 5; i++)
	{
		temp = strchr(content, flag_ch[i]);
		if(temp == NULL)
		{
			continue;
		}
		if((temp_min != NULL && temp_min > temp) || temp_min == NULL)
		{
			temp_min = temp;
		}
	}
	return temp_min;

}
char* str_locate(char *org_string, char *t_string)
{
	int i = 0;
	int org_len = 0, t_len = 0;

	org_len = strlen(org_string);
	t_len = strlen(t_string);

	for(i = 0; i <= org_len - t_len; i++)
	{
		if(!strncmp(org_string + i, t_string, t_len))
		{
			return (char* )(org_string + i);
		}
	}
	return NULL;
}
int _1905_read_dev_send_1905(struct p1905_managerd_ctx* ctx,
	char* name, unsigned char *almac, unsigned short* _type, unsigned short *tlv_len, unsigned char *pay_load)
{
	FILE* f;
	int i;
	char content[8192] = {0};
	unsigned short pay_load_len = 0;
	unsigned int value;
	char* pos1, *pos2;
	int al_mac_int[ETH_ALEN];
	unsigned char al_mac[ETH_ALEN];
	int msg_type = 0;
	signed char ch;
	unsigned char byte_value[3];
	unsigned char ts_tlv_flag =  0, ts_tlv_count = 0;
	unsigned char k = 0, num;
	unsigned char ssid[64] = {0};

	f = fopen(name, "r");
	if (f == NULL)
	{
		debug(DEBUG_ERROR, "open file %s fail\n", name);
		return -1;
	}

	memset(content, 0, sizeof(content));

	i = 0;

    do{
		ch = fgetc(f);
		if(ch == EOF)
			break;
		content[i++] = ch;
    }while(ch != EOF);
	debug(DEBUG_TRACE, "\n");

	hex_dump("raw content:", (unsigned char *)content, i);

	pos1 = content;
	/*al mac*/
	pos2 = strchr(pos1, ' ');
	if(pos2 == NULL)
	{
		debug(DEBUG_ERROR, "white space not found\n");
		goto error1;
	}
	*pos2 = '\0';
	sscanf(pos1, "%02x:%02x:%02x:%02x:%02x:%02x", al_mac_int, al_mac_int + 1,
		al_mac_int + 2, al_mac_int + 3, al_mac_int + 4, al_mac_int + 5);
	for(i = 0; i < 6; i++)
	{
		al_mac[i] = (unsigned char)al_mac_int[i];
	}
	pos2++;
	pos1 = pos2;
	debug(DEBUG_TRACE, "almac:%02x:%02x:%02x:%02x:%02x:%02x\n", PRINT_MAC(al_mac));


	/*msg type*/
	pos2 = strchr(pos1, '\n');
	if(pos2 == NULL)
	{
		debug(DEBUG_ERROR, "\\n not  found\n");
		goto error1;
	}
	*pos2 = '\0';
	sscanf(pos1, "0x%04x", &msg_type);
	pos2++;
	pos1 = pos2;
	debug(DEBUG_TRACE, "msg_type=0x%04x\n", msg_type);

	while(1)
	{
		pos1 = str_locate(pos1, "0x");
		/*end of data*/
		if(pos1 == NULL)
		{
			break;
		}
		/*skip '0x'*/
		pos1 += 2;

		pos2 = get_raw_data_end(pos1);

		if(pos2 == NULL)
		{
			debug(DEBUG_ERROR, "error find raw data end\n");
			goto error1;
		}
		if(pos2 < pos1)
		{
			debug(DEBUG_ERROR, "pos2 must larger than pos1\n");
			goto error1;
		}
		if(((int)(pos2 - pos1)) % 2 != 0)
		{
			pos1--;
			*pos1 = '0';
		}
		while(1)
		{
			memset(byte_value, 0, sizeof(byte_value));
			memcpy(byte_value, pos1, 2);
			sscanf((char *)byte_value, "%02x", &value);
			pay_load[pay_load_len++] = (unsigned char)value;
			pos1 += 2;
			if(pos1 >= pos2)
			{
				break;
			}
		}

		/* TS TLV will appear as:
		 * 00:0c:43:48:98:FC 0x8003
		 * 0xB5 0x0003 0x000A 0x00 0xB6 0x0014 0x02 0x0E Multi-AP-5GL-1 0x000A 0x0E Multi-AP-5GL-2 0x0014
		 */

		if (value == TRAFFIC_SEPARATION_POLICY_TYPE)
			ts_tlv_flag = 1;

		if (ts_tlv_flag == 1)
			ts_tlv_count++;

		if (ts_tlv_count == 3) {
			num = value;
			for (k = 0; k < num; k++) {
				pos1 = str_locate(pos1, "0x");
				/*skip '0x', parse ssid length*/
				pos1 += 2;

				memset(byte_value, 0, sizeof(byte_value));
				memcpy(byte_value, pos1, 2);
				sscanf((char *)byte_value, "%02x", &value);
				pay_load[pay_load_len++] = (unsigned char)value;
				pos1 += 2;

				pos1 += 1; /*skip '_'*/
				pos2 = get_raw_data_end(pos1);
				pos2 = '\0';
				memset(ssid, 0, 64);
				sscanf((char *)pos1, "%s", ssid);
				memcpy(&pay_load[pay_load_len], ssid, value);
				pay_load_len += value;

				debug(DEBUG_ERROR, "ssid len=%d, ssid:%s\n", value, ssid);

				/*vlan id*/
				pos1 = str_locate(pos1, "0x");
				/*skip '0x'*/
				pos1 += 2;
				pos2 = get_raw_data_end(pos1);
				do {
					memset(byte_value, 0, sizeof(byte_value));
					memcpy(byte_value, pos1, 2);
					sscanf((char *)byte_value, "%02x", &value);
					pay_load[pay_load_len++] = (unsigned char)value;
					pos1 += 2;
					if(pos1 >= pos2)
					{
						break;
					}
				}while(1);
				debug(DEBUG_ERROR, "vlanid:%u\n",
					(unsigned short)((pay_load[pay_load_len-2]<<8)|pay_load[pay_load_len-1]));
			}
			ts_tlv_flag = 0;
			ts_tlv_count = 0;
		}
	}

	hex_dump("dev_send_1905", pay_load, pay_load_len);
	*tlv_len = pay_load_len;
	*_type = (unsigned short)msg_type;
	memcpy(almac, al_mac, 6);
	fclose(f);
	return 0;
error1:
	fclose(f);
	return -1;


}
