#include <stdlib.h>
#include <stdio.h>
#include "multi_ap.h"
#include "wifi_utils.h"
#include "p1905_database.h"
#include "p1905_managerd.h"
#include "cmdu_tlv.h"
#include "debug.h"
#include "_1905_interface_ctrl.h"
#include "topology.h"
#include "os.h"

#define IEEE802_3_GROUP   0x0000
#define IEEE802_11_GROUP  0x0100
#define IEEE1901_GROUP    0x0200
#define MOCA_GROUP        0x0300

extern int _1905_interface_send(struct p1905_managerd_ctx *ctx, unsigned char* buf, size_t buf_len, char *dst_dameon);
extern int _1905_interface_recv(struct p1905_managerd_ctx *ctx, unsigned char* buf, int buf_len);
extern void _1905_interface_receive_process(int sock, void *eloop_ctx,
					      void *sock_ctx);
extern int _1905_interface_pending(struct p1905_managerd_ctx *ctx, struct timeval *tv);

unsigned char buf_io[15360];

/*get the bss with same priority or the bss with least priority which is larger that priority(argument 2)*/
struct config_bss_info *get_config_bss_by_priority(struct radio_info *rinfo, unsigned char priority)
{
	unsigned char i = 0, found = 0;
	unsigned char min_prio = 0xFF;
	unsigned char min_prio_index = 0;

	/*get the bss with same priority*/
	for (i = 0; i < rinfo->bss_number; i++) {
		if (rinfo->bss[i].priority == priority) {
			found = 1;
			break;
		}
	}

	if (found == 1)
		return &rinfo->bss[i];

	/*get the bss with least priority which is larger that priority*/
	for (i = 0; i < rinfo->bss_number; i++) {
		if (rinfo->bss[i].priority > priority && rinfo->bss[i].priority < min_prio) {
			min_prio = rinfo->bss[i].priority;
			min_prio_index = i;
			found = 1;
		}
	}

	if (found == 0)
		return NULL;

	return &rinfo->bss[min_prio_index];
}

unsigned char *fill_bss_config(unsigned char *setting, WSC_CONFIG *config, struct config_bss_info *bss)
{
	unsigned char *p = setting;

	memcpy(p, bss->mac, ETH_ALEN);
	p += ETH_ALEN;

	memcpy(p, config->Ssid, 33);
	p += 33;

	*(unsigned short*)p = config->AuthMode;
	p += 2;

	*(unsigned short*)p = config->EncrypType;
	p += 2;

	memcpy(p, config->WPAKey, 65);
	p += 65;

	*p++ = config->map_vendor_extension;

	*p++ = config->hidden_ssid;

	bss->config_status = 1;
#ifdef MAP_R2
	bss->config = *config;
#endif
	return p;
}

int _1905_set_wireless_setting(struct p1905_managerd_ctx* ctx)
{
	unsigned char i = 0, j = 0;
	unsigned char radio_index = 0;
	unsigned char *p = buf_io;
	unsigned char auto_config_num = 0;
	unsigned char priority = 1;
	int len = 0;
	struct config_bss_info *bss = NULL;
	WSC_CONFIG *config = NULL;
	struct _config_buf_ctrl *dst, *dst_n;
	char itf_buff_exist = 0;
	
	os_memset(buf_io, 0, sizeof(buf_io));
	
	if (ctx->current_autoconfig_info.radio_index != -1) {
		radio_index = (unsigned char)ctx->current_autoconfig_info.radio_index;
	} else {
		debug(DEBUG_ERROR, "%s radio_index error == -1!!!\n", __func__);
		return wapp_utils_error;
	}

	/*reset config_status*/
	for (i = 0; i < ctx->rinfo[radio_index].bss_number; i++)
		ctx->rinfo[radio_index].bss[i].config_status = 0;

	auto_config_num = (ctx->current_autoconfig_info.config_number <=
		ctx->rinfo[radio_index].bss_number) ?
		ctx->current_autoconfig_info.config_number :
		ctx->rinfo[radio_index].bss_number;
	debug(DEBUG_OFF, "total autoconf num=%d\n", auto_config_num);

	*(unsigned short*)p = _1905_SET_WIRELESS_SETTING_EVENT;
	p += 2;

	*(unsigned short*)p = auto_config_num * 110;
	p += 2;
	*(unsigned char*)p = (unsigned char)auto_config_num;
	p += 1;

	/*first fill the bss config by the priority*/
	i = 0;
	while ((bss = get_config_bss_by_priority(&ctx->rinfo[radio_index], priority)) != NULL) {
		priority = bss->priority + 1;
		config = &ctx->current_autoconfig_info.config_data[i];
		p = fill_bss_config(p, config, bss);
		debug(DEBUG_OFF, "interface=%s priority=%d config_SSID=%s hidden_ssid=%d\n",
			bss->ifname, bss->priority, config->Ssid, config->hidden_ssid);
		i++;

		if (i >= auto_config_num)
			break;
	}

	/*then fill the rest bss with no priority*/
	j = i;
	if (j < auto_config_num) {
		for(i = 0; i < ctx->rinfo[radio_index].bss_number; i++)
		{
			bss = &ctx->rinfo[radio_index].bss[i];
			if (bss->priority != 0)
				continue;
			config = &ctx->current_autoconfig_info.config_data[j++];

			p = fill_bss_config(p, config, bss);
			debug(DEBUG_TRACE, "interface=%s priority=%d config_SSID=%s hidden_ssid=%d\n",
				bss->ifname, bss->priority, config->Ssid, config->hidden_ssid);
			if (j >= auto_config_num)
				break;
		}
	}
	len = (int)(p - buf_io);

	if(ctx->is_renew_ongoing) {
		dl_list_for_each_safe(dst, dst_n, &ctx->config_buffer.list, struct _config_buf_ctrl, list) {
			if(!memcmp(bss->ifname, dst->itf_name, strlen((char *)dst->itf_name))) {
				debug(DEBUG_TRACE, "found the same interface in buffer mode, replace it\n");
				itf_buff_exist = 1;
				free(dst->config_buff);
				dst->config_buff = (unsigned char *)malloc(len);
				memset(dst->config_buff, 0, len);
				memcpy(dst->config_buff, buf_io, len);
				dst->len = len;
				break;
			}
		}

		if(!itf_buff_exist) {
			//alloc a new node and link to the list
			debug(DEBUG_TRACE, "alloc a new node\n");
			dst = (struct _config_buf_ctrl *)malloc(sizeof(*dst));
			memset(dst, 0 , sizeof(*dst));
			dst->itf_name = bss->ifname;
			dst->config_buff = (unsigned char *)malloc(len);
			memset(dst->config_buff, 0, len);
			memcpy(dst->config_buff, buf_io, len);
			dst->len = len;

			dl_list_add(&ctx->config_buffer.list, &dst->list);
		}
	}else {
		_1905_interface_send(ctx, buf_io, (size_t)len, NULL);
	}

    return wapp_utils_success;
}

int _1905_flash_out_config(struct p1905_managerd_ctx* ctx) {
	struct _config_buf_ctrl *dst, *dst_n;
	debug(DEBUG_OFF, "_1905_flash_out_config ++\n");

	dl_list_for_each_safe(dst, dst_n, &ctx->config_buffer.list, struct _config_buf_ctrl, list) {
		debug(DEBUG_OFF, "itf_name: %s\n", dst->itf_name);
		_1905_interface_send(ctx, dst->config_buff, (size_t)dst->len, NULL);
		free(dst->config_buff);
		dl_list_del(&dst->list);
		free(dst);
		os_sleep(1, 0);
	}

	return wapp_utils_success;
}

int _1905_wait_parse_spec_event(struct p1905_managerd_ctx* ctx, unsigned char* buf, int len, unsigned char event_type, long sec, long usec)
{

	struct timeval tv;
	int ret = 0;
	int res = 0;

	tv.tv_sec = sec;
	tv.tv_usec = usec;
	while(1)
	{
		ret = _1905_interface_pending(ctx, &tv);
		if(ret == 1)
		{
			if(_1905_interface_recv(ctx, buf, len) < 0)
			{
				debug(DEBUG_ERROR, "_1905_interface_recv fail\n");
			    return wapp_utils_error;
			}
			else
			{
				res = map_event_handler(ctx, (char* )buf, len, event_type);
				if (res == 0) {
					return wapp_utils_success;
				} else if (res == -2) {
					return wapp_utils_error;
				}
			}
		}
		else
		{
			debug(DEBUG_ERROR, "wait for event timeout\n");
			return wapp_utils_error;
		}
	}
}


int _1905_event_notify(struct p1905_managerd_ctx* ctx, unsigned short event_id, unsigned char* peer_al_mac)
{
	unsigned char *p = buf_io;
	int len = 0;
	unsigned short notification_len = 0;

	memset(p, 0, 15360);
	*(unsigned short*)p = event_id;
	p += 2;

	notification_len = ctx->revd_tlv_len;
	if(peer_al_mac != NULL)
	{
		notification_len += ETH_ALEN;
	}

	*(unsigned short*)p = notification_len;
	p += 2;

	if(peer_al_mac != NULL)
	{
		memcpy(p, peer_al_mac, ETH_ALEN);
		p += ETH_ALEN;
	}

	memcpy(p, ctx->revd_tlv, ctx->revd_tlv_len);
	p += ctx->revd_tlv_len;

	len = (int)(p - buf_io);
	if (_1905_interface_send(ctx, buf_io, len, NULL))
   		return wapp_utils_success;
	else
		return wapp_utils_error;

}

void _1905_set_steering_setting(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_STEERING_REQUEST_EVENT, al_mac);
}

void _1905_set_client_assoc_ctrl(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CLIENT_ASSOC_CNTRL_SETTING_EVENT, al_mac);
}

void _1905_set_map_policy_config(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_POLICY_CONFIG_REQUEST_EVENT, al_mac);
}

int _1905_notify_ap_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac
#ifdef MAP_R2
, unsigned char periodic
#endif
)
{
	unsigned short event_id = 0;
#ifdef MAP_R2
	if (periodic)
		event_id = _1905_RECV_AP_METRICS_QUERY_PERIODIC_EVENT;
	else
#endif
		event_id = _1905_RECV_AP_METRICS_QUERY_EVENT;

	_1905_event_notify(ctx, event_id, al_mac);
	if(_1905_wait_parse_spec_event(ctx, buf_io, sizeof(buf_io), WAPP_AP_METRICS_RSP_INFO, 2, 1) < 0)
	{
		debug(DEBUG_ERROR, "error\n");
		return -1;
	}
	return 0;
}

int _1905_notify_bh_steering_req(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_BACKHAUL_STEER_REQ_EVENT, al_mac);

	return 0;
}

int _1905_notify_assoc_sta_link_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	if (_1905_event_notify(ctx, _1905_RECV_ASSOC_STA_LINK_METRICS_QUERY_EVENT, al_mac) < 0) {
		debug(DEBUG_ERROR, "no daemon attached! no need wait LIB_ONE_ASSOC_STA_LINK_METRICS\n");
		return -1;
	}
	if(_1905_wait_parse_spec_event(ctx, buf_io, sizeof(buf_io), LIB_ONE_ASSOC_STA_LINK_METRICS, 2, 1) < 0)
	{
		debug(DEBUG_ERROR, "error\n");
		return -1;
	}
	return 0;
}

int _1905_notify_link_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	if (_1905_event_notify(ctx, _1905_RECV_LINK_METRICS_QUERY, al_mac) < 0) {
		debug(DEBUG_ERROR, "no daemon attached! no need wait WAPP_LINK_METRICS_RSP_INFO\n");
		return -1;
	}
	if(_1905_wait_parse_spec_event(ctx, buf_io, sizeof(buf_io), WAPP_LINK_METRICS_RSP_INFO, 2, 1) < 0)
	{
		debug(DEBUG_ERROR, "error\n");
		return -1;
	}
	return 0;
}

int _1905_notify_unassoc_sta_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	if (_1905_event_notify(ctx, _1905_RECV_UNASSOC_STA_LINK_METRICS_QUERY_EVENT, al_mac) < 0) {
		debug(DEBUG_ERROR, "no daemon attached! no need wait LIB_UNASSOC_STA_LINK_METRICS\n");
		return -1;
	}
	if(_1905_wait_parse_spec_event(ctx, buf_io, sizeof(buf_io), LIB_UNASSOC_STA_LINK_METRICS, 2, 1) < 0)
	{
		debug(DEBUG_ERROR, "error\n");
		return -1;
	}
	return 0;
}

int _1905_set_radio_tear_down(struct p1905_managerd_ctx* ctx, unsigned char* radio_identifier)
{
	unsigned char buf[256];
	unsigned char* p = buf;
	*(unsigned short*)p = _1905_SET_RADIO_TEARED_DOWN_EVENT;
	p += 2;

	*(unsigned short*)p = 6;
	p += 2;

	memcpy(p, radio_identifier, ETH_ALEN);
	p += ETH_ALEN;
	_1905_interface_send(ctx, buf, (size_t)(p - buf), NULL);
	return 0;
}

void _1905_notify_beacon_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_BEACON_METRICS_QUERY_EVENT, al_mac);
}

void _1905_notify_controller_found(struct p1905_managerd_ctx* ctx)
{
	unsigned char buf[256];
	unsigned char* p = buf;
	int i = 0;

	*(unsigned short*)p = _1905_MAP_CONTROLLER_FOUND_EVENT;
	p += 2;

	*(unsigned short*)p = 24;
	p += 2;

	*p++ = ctx->cinfo.supported_freq;

	for(i = 0; i < ctx->itf_number; i++)
	{
		if(!memcmp(ctx->cinfo.local_ifname, ctx->itf[i].if_name, IFNAMSIZ))
		{
			if(ctx->itf[i].media_type == IEEE802_3_GROUP)
			{
				*p++ = 0;
			}
			else if((ctx->itf[i].media_type & IEEE802_11_GROUP))
			{
				*p++ = 1;
			}
			memcpy(p, ctx->itf[i].if_name, IFNAMSIZ);
			p += IFNAMSIZ;
			memcpy(p, ctx->itf[i].mac_addr, ETH_ALEN);
			p += ETH_ALEN;
			break;
		}
	}
	_1905_interface_send(ctx, buf, (size_t)(p - buf), NULL);
}

int _1905_notify_channel_selection_req(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	if (_1905_event_notify(ctx, _1905_RECV_CHANNEL_SELECTION_REQ_EVENT, al_mac) < 0) {
		debug(DEBUG_ERROR, "no daemon attached! no need wait WAPP_CHANNEL_SELECTION_RSP_INFO\n");
		return -1;
	}
	if(_1905_wait_parse_spec_event(ctx, buf_io, sizeof(buf_io), WAPP_CHANNEL_SELECTION_RSP_INFO, 2, 1) < 0)
	{
		debug(DEBUG_ERROR, "error\n");
		return -1;
	}
	return 0;
}

int _1905_notify_channel_preference_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	unsigned char *p = buf_io;
	unsigned char i = 0;
	*(unsigned short*)p = _1905_RECV_CHANNEL_PREFERENCE_QUERY_EVENT;
	p += 2;

	*(unsigned short*)p = ETH_ALEN + 1 + ctx->radio_number * ETH_ALEN;
	p += 2;

	memcpy(p, al_mac, ETH_ALEN);
	p += ETH_ALEN;

	*p++ = ctx->radio_number;

	for(i = 0; i < ctx->radio_number; i++)
	{
		memcpy(p, ctx->rinfo[i].identifier, ETH_ALEN);
		p += ETH_ALEN;
	}
	if (_1905_interface_send(ctx, buf_io, (size_t)(p - buf_io), NULL) == 0) {
		debug(DEBUG_ERROR, "no daemon attached! no need wait WAPP_CHANNEL_PREFERENCE_REPORT_INFO\n");
		return -1;
	}

	if(_1905_wait_parse_spec_event(ctx, buf_io, sizeof(buf_io), WAPP_CHANNEL_PREFERENCE_REPORT_INFO, 2, 1) < 0)
	{
		debug(DEBUG_ERROR, "error\n");
		return -1;
	}
	return 0;
}

void _1905_notify_channel_preference_report(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CHANNEL_PREFERENCE_REPORT_EVENT, al_mac);
}

void _1905_notify_client_steering_btm_report(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CLI_STEER_BTM_REPORT_EVENT, al_mac);
}

void _1905_notify_steering_complete(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_STEER_COMPLETE_EVENT, al_mac);
}

void _1905_notify_ap_metrics_response(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_AP_METRICS_RSP_EVENT, al_mac);
}

void _1905_notify_link_metrics_response(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_LINK_METRICS_RSP_EVENT, al_mac);
}

void _1905_notify_assoc_sta_link_metric_rsp(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_ASSOC_STA_LINK_METRICS_RSP_EVENT, al_mac);
}

void _1905_notify_unassoc_sta_link_metric_rsp(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_UNASSOC_STA_LINK_METRICS_RSP_EVENT, al_mac);
}

void _1905_notify_bcn_metric_rsp(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_BCN_METRICS_RSP_EVENT, al_mac);
}

void _1905_notify_bh_steering_rsp(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_BACKHAUL_STEER_RSP_EVENT, al_mac);
}

void _1905_notify_combined_infra_metrics(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_COMBINED_INFRASTRUCTURE_METRICS_EVENT, al_mac);
}

void _1905_notify_vendor_specific_message(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_VENDOR_SPECIFIC_MESSAGE_EVENT, al_mac);
}

void _1905_notify_topology_rsp_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac, unsigned char* local_if_mac)
{
	/*insert the local interface mac address to the almac*/
	memcpy(buf_io, ctx->revd_tlv, ctx->revd_tlv_len);
	memcpy(ctx->revd_tlv, local_if_mac, ETH_ALEN);
	memcpy(ctx->revd_tlv + ETH_ALEN, buf_io, ctx->revd_tlv_len);
	ctx->revd_tlv_len += ETH_ALEN;
	_1905_event_notify(ctx, _1905_RECV_TOPOLOGY_RSP_EVENT, al_mac);
}

void _1905_notify_renew_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac, unsigned char renew_band)
{
	unsigned char *p = buf_io;

	*((unsigned short*)p) = _1905_AUTOCONFIG_RENEW_EVENT;
	p += 2;

	*((unsigned short*)p) = 7;
	p += 2;

	memcpy(p, al_mac, ETH_ALEN);
	p += ETH_ALEN;

	*p++ = renew_band;

	_1905_interface_send(ctx, buf_io, (size_t)(p - buf_io), NULL);
}

void _1905_notify_autoconfig_rsp_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_AUTOCONFIG_RSP_EVENT, al_mac);
}

void _1905_notify_topology_notification_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_TOPOLOGY_NOTIFICATION_EVENT, al_mac);
}

void _1905_notify_ap_capability_report_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_AP_CAPABILITY_REPORT_EVENT, al_mac);
}

void _1905_notify_ch_selection_rsp_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CH_SELECTION_RSP_EVENT, al_mac);
}

void _1905_notify_operating_channel_report_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_OPERATING_CH_REPORT_EVENT, al_mac);
}

void _1905_notify_client_capability_report_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CLIENT_CAPABILITY_REPORT_EVENT, al_mac);
}

void _1905_notify_higher_layer_data_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_HIGHER_LAYER_DATA_EVENT, al_mac);
}

void _1905_notify_raw_data(struct p1905_managerd_ctx *ctx, unsigned char *buf, size_t len)
{
	_1905_interface_send(ctx, buf, len, NULL);
}

void _1905_notify_combined_infrastructure_metrics_query(struct p1905_managerd_ctx* ctx,
	unsigned char* al_mac, unsigned char *peer_almac)
{
	unsigned char *p = buf_io;

	*((unsigned short*)p) = _1905_RECV_COMBINED_INFRASTRUCTURE_METRICS_QUERY_EVENT;
	p += 2;

	*((unsigned short*)p) = 12;
	p += 2;

	memcpy(p, al_mac, ETH_ALEN);
	p += ETH_ALEN;

	memcpy(p, peer_almac, ETH_ALEN);
	p += ETH_ALEN;

	_1905_interface_send(ctx, buf_io, (size_t)(p - buf_io), NULL);
}

void _1905_notify_switch_status(struct p1905_managerd_ctx* ctx, unsigned char status)
{
	unsigned char *p = buf_io;

	*((unsigned short*)p) = _1905_SWITCH_STATUS;
	p += 2;

	*((unsigned short*)p) = 1;
	p += 2;

	*p++ = status;

	_1905_interface_send(ctx, buf_io, (size_t)(p - buf_io), NULL);
}

extern	struct config_bss_info *get_config_bss_by_priority(struct radio_info *rinfo, unsigned char priority);
extern 	unsigned char *fill_bss_config(unsigned char *setting, WSC_CONFIG *config, struct config_bss_info *bss);

int _1905_update_bss_info_per_radio(struct p1905_managerd_ctx *ctx,
	struct radio_info *rinfo)
{
	unsigned char i = 0, j = 0, ji = 0, sum = 0;
	unsigned char config_intf_num_per_radio = 0, bss_config_num_per_radio = 0, auto_config_num = 0;
	unsigned char *p = buf_io;
	int len = 0;
	unsigned char wild_card_mac[ETH_ALEN] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
	struct radio_basic_capability_db *basic_cap = NULL;
	struct basic_cap_db *bcap = NULL;
	unsigned char radio_cap = BAND_INVALID_CAP, cap = BAND_INVALID_CAP;
	unsigned char band = BAND_UNKNOWN;
	struct config_bss_info *bss;
	unsigned char priority = 1;
	WSC_CONFIG config;

	memset(&config, 0, sizeof(config));
	config_intf_num_per_radio = rinfo->bss_number;
	/*get radio band cap*/
	SLIST_FOREACH(basic_cap, &ctx->ap_cap_entry.basic_cap_head, bcap_entry)
	{
		if (!memcmp(basic_cap->identifier, rinfo->identifier, ETH_ALEN)) {
			SLIST_FOREACH(bcap, &basic_cap->bcap_head, basic_cap_entry)
			{
				cap = get_bandcap(ctx, bcap->op_class, bcap->non_operch_num, bcap->non_operch_list);
				radio_cap |= cap;
			}
			break;
		}
	}
	debug(DEBUG_TRACE, "radio_cap=%d\n", radio_cap);
	if (radio_cap == BAND_INVALID_CAP) {
		debug(DEBUG_ERROR, "invalid radio cap; no need config this radio\n");
		return wapp_utils_error;
	}

	band = determin_band_config(ctx, ctx->p1905_al_mac_addr, radio_cap);
	if (band == BAND_UNKNOWN) {
		debug(DEBUG_OFF, "no bss config info for this radio."
			"need send tear down event to this radio(%02x:%02x:%02x:%02x:%02x:%02x)\n", PRINT_MAC(rinfo->identifier));
		_1905_set_radio_tear_down(ctx, rinfo->identifier);
		return wapp_utils_success;
	}

	debug(DEBUG_TRACE, "band=%d\n", band);
	for (i = 0; i < ctx->bss_config_num; i++) {
		if ((((band == BAND_2G && ctx->bss_config[i].oper_class[0] == '8')
			|| (band == BAND_5GL && ctx->bss_config[i].oper_class[1] == '1')
			|| (band == BAND_5GH && ctx->bss_config[i].oper_class[1] == '2'))) &&
			(!memcmp(ctx->p1905_al_mac_addr, ctx->bss_config[i].mac, ETH_ALEN) ||
				!memcmp(ctx->bss_config[i].mac, wild_card_mac, ETH_ALEN))) {
				bss_config_num_per_radio++;
		}
	}
	debug(DEBUG_TRACE, "bss_config_num_per_radio=%d\n", bss_config_num_per_radio);

	if (bss_config_num_per_radio == 0) {
		debug(DEBUG_OFF, "no bss config info for this device on this radio."
			" need send tear down event to this radio\n");
		_1905_set_radio_tear_down(ctx, rinfo->identifier);
		return wapp_utils_success;
	}

	auto_config_num = (config_intf_num_per_radio <= bss_config_num_per_radio) ?
		config_intf_num_per_radio : bss_config_num_per_radio;
	debug(DEBUG_TRACE, "total autoconf num=%d\n", auto_config_num);

	*(unsigned short*)p = _1905_SET_WIRELESS_SETTING_EVENT;
	p += 2;

	*(unsigned short*)p = auto_config_num * 110;
	p += 2;
	*(unsigned char*)p = (unsigned char)auto_config_num;
	p += 1;

	/*first fill the bss config by the priority*/
	i = 0;
	while ((bss = get_config_bss_by_priority(rinfo, priority)) != NULL) {
		priority = bss->priority + 1;
		for (j = ji; j < ctx->bss_config_num; j++) {
			if ((((band == BAND_2G && ctx->bss_config[j].oper_class[0] == '8')
				|| (band == BAND_5GL && ctx->bss_config[j].oper_class[1] == '1')
				|| (band == BAND_5GH && ctx->bss_config[j].oper_class[1] == '2'))) &&
				(!memcmp(ctx->p1905_al_mac_addr, ctx->bss_config[j].mac, ETH_ALEN) ||
					!memcmp(ctx->bss_config[j].mac, wild_card_mac, ETH_ALEN))) {
				ji = j + 1;
				config.AuthMode = ctx->bss_config[j].authmode;
				config.EncrypType = ctx->bss_config[j].encryptype;
				config.map_vendor_extension = ctx->bss_config[j].wfa_vendor_extension;
				config.hidden_ssid = ctx->bss_config[j].hidden_ssid;
				os_memcpy(config.Ssid, ctx->bss_config[j].ssid, 33);
				os_memcpy(config.WPAKey, ctx->bss_config[j].key, 65);
				break;
			}
		}
		p = fill_bss_config(p, &config, bss);
		debug(DEBUG_TRACE, "interface=%s priority=%d config_SSID=%s, hidden_ssid=%d\n",
			bss->ifname, bss->priority, config.Ssid, config.hidden_ssid);
		i++;

		if (i >= auto_config_num)
			break;
	}

	/*then fill the rest bss with no priority*/
	sum = i;
	if (sum < auto_config_num) {
		for(i = 0; i < rinfo->bss_number; i++)
		{
			bss = &rinfo->bss[i];
			if (bss->priority != 0)
				continue;
			for (j = ji; j < ctx->bss_config_num; j++) {
				if ((((band == BAND_2G && ctx->bss_config[j].oper_class[0] == '8')
					|| (band == BAND_5GL && ctx->bss_config[j].oper_class[1] == '1')
					|| (band == BAND_5GH && ctx->bss_config[j].oper_class[1] == '2'))) &&
					(!memcmp(ctx->p1905_al_mac_addr, ctx->bss_config[j].mac, ETH_ALEN) ||
					!memcmp(ctx->bss_config[j].mac, wild_card_mac, ETH_ALEN))) {
						ji = j + 1;
						config.AuthMode = ctx->bss_config[j].authmode;
						config.EncrypType = ctx->bss_config[j].encryptype;
						config.map_vendor_extension = ctx->bss_config[j].wfa_vendor_extension;
						config.hidden_ssid = ctx->bss_config[j].hidden_ssid;
						os_memcpy(config.Ssid, ctx->bss_config[j].ssid, 33);
						os_memcpy(config.WPAKey, ctx->bss_config[j].key, 65);
						break;
				}
			}
			sum++;
			p = fill_bss_config(p, &config, bss);
			debug(DEBUG_TRACE, "interface=%s priority=%d config_SSID=%s, hidden_ssid=%d\n",
				bss->ifname, bss->priority, config.Ssid, config.hidden_ssid);
			if (sum >= auto_config_num)
				break;
		}
	}

	debug(DEBUG_TRACE, "config bss number(%d)\n", auto_config_num);

	len = (int)(p - buf_io);
	_1905_interface_send(ctx, buf_io, (size_t)len, NULL);

	if (ctx->root_leaf) {
		ctx->root_leaf->config_status = CONFIGURED_2G | CONFIGURED_5G;
	}

	return wapp_utils_success;
}

#ifdef MAP_R2

/*channel scan feature*/
int _1905_notify_ch_scan_req(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CHANNEL_SCAN_REQ_EVENT, al_mac);

	return 0;
}

int _1905_notify_ch_scan_rep(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CHANNEL_SCAN_REP_EVENT, al_mac);

	return 0;
}


int _1905_notify_tunneled_msg(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_TUNNELED_MESSAGE_EVENT, al_mac);

	return 0;
}


int _1905_notify_assoc_status_notification_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_ASSOCIATION_STATUS_NOTIFICATION_EVENT, al_mac);

	return 0;
}


int _1905_notify_cac_request_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CAC_REQUEST_EVENT, al_mac);

	return 0;
}


int _1905_notify_cac_terminate_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CAC_TERMINATE_EVENT, al_mac);

	return 0;
}


int _1905_notify_client_disassociation_stats_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_CLIENT_DISASSOCIATION_STATS_EVENT, al_mac);

	return 0;
}

int _1905_notify_failed_assoc_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac)
{
	_1905_event_notify(ctx, _1905_RECV_FAILED_ASSOCIATION_EVENT, al_mac);

	return 0;
}

#define VLAN_N_VID		4096
unsigned short get_vid_from_ssid(char *ssid, unsigned char num,
	struct ssid_2_vid_mapping *mapping)
{
	unsigned char i = 0;

	for (i = 0; i < num; i++) {
		if (!os_strncmp(ssid, mapping[i].ssid, 32))
			return mapping[i].vlan_id;
	}

	return VLAN_N_VID;
	
}
void _1905_notify_ts_bh_setting(struct p1905_managerd_ctx *ctx, unsigned char num,
	struct ssid_2_vid_mapping *mapping)
{
	struct ts_bh_setting *ts_bh = NULL;
	unsigned char *p = buf_io;
	unsigned char i = 0, j = 0, fh_count = 0, bh_count = 0;
	struct config_bss_info *bss = NULL;
	unsigned short vid = VLAN_N_VID;
	
	os_memset(buf_io, 0, sizeof(buf_io));
	*(unsigned short*)p = _1905_SET_TRAFFIC_SEPARATION_BH_SETTING_EVENT;
	p += 2;

	ts_bh = (struct ts_bh_setting*)(p + 2);
	ts_bh->bh_configs.primary_vid = ctx->map_policy.setting.primary_vid;
	ts_bh->bh_configs.primary_pcp = ctx->map_policy.setting.dft.PCP;

	for (i = 0; i < ctx->radio_number; i++) {
		for (j = 0; j < ctx->rinfo[i].bss_number; j++) {
			bss = &ctx->rinfo[i].bss[j];

			if (bss->config_status == 0)
				continue;

			/*if (bss->config.map_vendor_extension & BIT_BH_BSS) */{
			/*backhaul*/
				os_memcpy(&ts_bh->apply_itf_mac[bh_count * ETH_ALEN], bss->mac, ETH_ALEN);
				bh_count++;
			}		
			
			vid = get_vid_from_ssid((char*)bss->config.Ssid, num, mapping);
			if (vid == VLAN_N_VID)
				continue;
			
			/*fronthaul*/
			ts_bh->bh_configs.vids[fh_count++] = vid;				
		}
	}
	ts_bh->bh_configs.fh_vid_num = fh_count;

	for (i = 0; i < ctx->itf_number; i++) {
		if (ctx->itf[i].is_wifi_sta) {
			os_memcpy(&ts_bh->apply_itf_mac[bh_count * ETH_ALEN], ctx->itf[i].mac_addr, ETH_ALEN);
			bh_count++;
		}
	}

	ts_bh->apply_itf_num = bh_count;
	debug(DEBUG_OFF, "ts_bh fh_count=%d, bh_count=%d\n", fh_count, bh_count);

	*(unsigned short*)p = sizeof(struct ts_bh_setting) + bh_count * ETH_ALEN;
	
	_1905_interface_send(ctx, buf_io, sizeof(struct ts_bh_setting) + bh_count * ETH_ALEN + 4, NULL);
}

void _1905_notify_ts_fh_setting(struct p1905_managerd_ctx *ctx, unsigned char num,
	struct ssid_2_vid_mapping *mapping)
{	
	struct ts_fh_setting *ts_fh = NULL;	
	unsigned char *p = buf_io;
	unsigned char i = 0, j = 0, fh_count = 0;
	struct config_bss_info *bss = NULL;
	unsigned short vid = VLAN_N_VID;
	
	os_memset(buf_io, 0, sizeof(buf_io));
	*(unsigned short*)p = _1905_SET_TRAFFIC_SEPARATION_FH_SETTING_EVENT;
	p += 2;

	ts_fh = (struct ts_fh_setting*)(p + 2);
	
	for (i = 0; i < ctx->radio_number; i++) {
		for (j = 0; j < ctx->rinfo[i].bss_number; j++) {
			bss = &ctx->rinfo[i].bss[j];

			if (bss->config_status == 0)
				continue;

			vid = get_vid_from_ssid((char*)bss->config.Ssid, num, mapping);
			if (vid == VLAN_N_VID)
				continue;
			
			/*fronthaul*/
			if (bss->config.map_vendor_extension & BIT_FH_BSS) {
				os_memcpy(ts_fh->fh_configs[fh_count].itf_mac, bss->mac, ETH_ALEN);
				ts_fh->fh_configs[fh_count].vid = vid;
				fh_count++;
			} 	
		}
	}
	ts_fh->itf_num = fh_count;
	debug(DEBUG_OFF, "ts_bh fh_count=%d\n", fh_count);
	
	*(unsigned short*)p = sizeof(struct ts_fh_setting) + fh_count * sizeof(struct ts_fh_config);

	_1905_interface_send(ctx, buf_io, 
		sizeof(struct ts_fh_setting) + fh_count * sizeof(struct ts_fh_config) + 4, NULL);
}

#endif // #ifdef MAP_R2
