#ifndef __STACK_H__
#define __STACK_H__

#include "debug.h"

#ifndef ETH_ALEN
#define ETH_ALEN 6
#endif

#define MAX_AGENT_COUNT 100

typedef struct {
	unsigned char al_mac[ETH_ALEN];
	unsigned char band_cap;
	unsigned char radio_cap;
	unsigned char cur_renew_band;
	unsigned char cur_renew_radio;
	unsigned char fin_renew_radio;
	unsigned char renew_retry_cnt;
	unsigned short m2_ack_mid;
}leaf_info;

typedef struct {
	int top;
	leaf_info arr[MAX_AGENT_COUNT];
}stack;

static inline void stack_init(stack s) {
	s.top = 0;

	return;
}

static inline int stack_empty(stack s) {
	if (s.top == 0)
		return 1;
	else
		return 0;
}

static inline int push(stack *sp, leaf_info l) {
	sp->top += 1;
	sp->arr[sp->top] = l;

	return 0;
}

static inline int pop(stack *sp, leaf_info *pl) {
	if (sp->top == 0)
		return -1;

	*pl = sp->arr[sp->top];
	sp->top--;

	return 0;
}

static inline int get_top(stack *sp, leaf_info **pl) {
	if (sp->top == 0)
		return -1;

	*pl = &sp->arr[sp->top];

	return 0;
}

static inline int pop_node(stack *sp) {
	if (sp->top == 0) {
		debug(DEBUG_ERROR, "BUG here!!!! top == 0\n");
		return -1;
	}
	sp->top--;

	return 0;
}

static inline void empty_stack(stack *s) {
	s->top = 0;
}


#endif