/*
 * cleopatre/application/p1905_managerd/inc/p1905_utils.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#ifndef P1905_UTILS_H
#define P1905_UTILS_H

#include "p1905_managerd.h"

/** Interfaces name */
#define ETH0   "eth0"
#define PLC0   "plc0"

/*tx/rx link statistics*/
typedef struct
{
    unsigned int total_tx_packets;
    unsigned int error_tx_packets;
    unsigned int total_rx_packets;
    unsigned int error_rx_packets;
} link_stat;

/*thread ctx*/
typedef struct
{
    unsigned short mmtype;
    unsigned char *local_itf;
    unsigned char *recv_buf;
} thread_ctx;

int get_receive_port_addr(unsigned char *brname,unsigned char *inputmac,unsigned char *outputmac);
void dump_topology_info(struct p1905_managerd_ctx *ctx);
void dump_topology_tree(struct p1905_managerd_ctx *ctx);
int is_topology_changed(struct list_head_tpddb *tpd_head,
            struct non_p1905_neighbor *dev);
void update_non_1905_device_from_fdb(struct list_head_tpddb *tpd_head,
    struct non_p1905_neighbor *dev);

void show_PON_dev(struct p1905_managerd_ctx *ctx);


#endif /* P1905_UTILS_H */
