#ifndef _MAPFILTER_IF_H
#define _MAPFILTER_IF_H

#ifndef GNU_PACKED
#define GNU_PACKED  __attribute__ ((packed))
#endif /* GNU_PACKED */

/*---------------------------------->
consistent in both kernel prog and user prog
*/

#define MAP_NETLINK 26
#ifndef ETH_ALEN
#define ETH_ALEN 6
#endif

enum DEVICE_TYPE {
	AP = 0,
	APCLI,
	ETH,
};

#define INF_UNKNOWN		0x00
#define INF_PRIMARY		0x01
#define INF_NONPRIMARY	0x02

#define _24G 0x01
#define _5GL 0x02
#define _5GH 0x04
#define _5G	0x06

enum MAP_NETLINK_EVENT_TYPE {
	UPDATE_MAP_NET_DEVICE = 0,
	SET_PRIMARY_INTERFACE,
	SET_UPLINK_PATH_ENTRY,
	DUMP_DEBUG_INFO,
	UPDATE_APCLI_LINK_STATUS,
	UPDATE_CHANNEL_UTILIZATION,
	DYNAMIC_LOAD_BALANCE,
#ifdef MAP_R2
	SET_TRAFFIC_SEPARATION_DEFAULT_8021Q,
	SET_TRAFFIC_SEPARATION_POLICY,
#endif
};

struct GNU_PACKED map_netlink_message {
	unsigned char type;
	unsigned short len;
	unsigned char event[0];
};

struct GNU_PACKED local_interface {
	char name[IFNAMSIZ];
	unsigned char mac[ETH_ALEN];
	enum DEVICE_TYPE dev_type;
	unsigned char band;
};

struct GNU_PACKED local_itfs {
	unsigned char num;
	struct local_interface inf[0];
};

struct GNU_PACKED primary_itf_setting {
	struct local_interface inf;
	unsigned char primary;
};

struct GNU_PACKED up_link_path_setting {
	struct local_interface in;
	struct local_interface out;
};

struct GNU_PACKED apcli_link_status {
	struct local_interface in;
	unsigned char link_status;
};


#ifdef MAP_R2
struct GNU_PACKED ssid_2_vid_mapping {
	char ssid[32];
	unsigned short vlan_id;
};

struct GNU_PACKED ts_policy {
	unsigned char num;
	struct ssid_2_vid_mapping ssid_2_vid[0];
};

struct GNU_PACKED ts_default_8021q {
	unsigned short primary_vid;
	unsigned char default_pcp;
};

#endif

int mapfilter_netlink_init(unsigned int pid);
int mapfilter_netlink_deinit(int sock);
int mapfilter_set_all_interface(struct local_itfs *itf);
int mapfilter_set_primary_interface(struct local_interface *itf, unsigned char primary);
int mapfilter_set_uplink_path(struct local_interface *in, struct local_interface *out);
int mapfilter_dump_debug_info();
#ifdef MAP_R2
int mapfilter_set_ts_default_8021q(unsigned short primary_vid, unsigned char default_pcp);
int mapfilter_set_ts_policy(unsigned char num, struct ssid_2_vid_mapping *mapping);
#endif

#endif

