/*
 * cleopatre/application/p1905_managerd/inc/lldp_message.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#ifndef LLDP_MESSAGE_H
#define LLDP_MESSAGE_H

#include <linux/if_ether.h>

#define LLDPDU_HLEN    2

#define END_OF_LLDPDU_TLV_TYPE  0
#define CHASSIS_ID_TLV_TYPE     1
#define PORT_ID_TLV_TYPE        2
#define TIME_TO_LIVE_TLV_TYPE   3

/*chassis id tlv subtype*/
#define C_CHASSIS_COMPONENT 1
#define C_INTERFACE_ALIAS   2
#define C_PORT_COMPONENT    3
#define C_MAC_ADDRESS       4
#define C_NETWORK_ADDRESS   5
#define C_INTERFACE_NAME    6
#define C_LOCAL_ASSIGN      7

/*port id tlv subtype*/
#define P_INTERFACE_ALIAS   1
#define P_PORT_COMPONENT    2
#define P_MAC_ADDRESS       3
#define P_NETWORK_ADDRESS   4
#define P_INTERFACE_NAME    5
#define P_AGENT_CIRCUIT_ID  6
#define P_LOCAL_ASSIGN      7

typedef union
{
    __be16 lldpdu_hdr;

    struct lldphdr
    {
        __be16 info_str_len:9;
        __be16 tlv_type:7;

    }lldpdu_msg;
}lldpdu_message_header;


unsigned short append_lldpdu_chassis_id_tlv(unsigned char *pkt,
                                            unsigned char *al_mac);

unsigned short append_lldpdu_port_id_tlv(unsigned char *pkt,
                                         unsigned char *itf_mac);

unsigned short append_lldpdu_time_to_live_tlv(unsigned char *pkt);

unsigned short append_lldpdu_end_of_lldpdu_tlv(unsigned char *pkt);

unsigned short create_802_1_bridge_discovery_message(unsigned char *buf,
                            unsigned char *al_mac, unsigned char *itf_mac);

#endif /* LLDP_MESSAGE_H */
