/****************************************************************************
 * Ralink Tech Inc.
 * Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************/

/****************************************************************************
    Module Name:
    HMAC

    Abstract:
    FIPS 198: The Keyed-Hash Message Authentication Code (HMAC)

    Revision History:
    Who         When            What
    --------    ----------      ------------------------------------------
    Eddy        2008/11/24      Create HMAC-SHA1, HMAC-SHA256
***************************************************************************/

#ifndef __CRYPT_HMAC_H__
#define __CRYPT_HMAC_H__
typedef unsigned long long UINT64;
typedef unsigned int UINT32;
typedef unsigned short UINT16;
typedef unsigned int UINT;
typedef int INT;
typedef unsigned char UINT8;
#define IN
#define OUT
#define INOUT
#define VOID void


#define HMAC_SHA1_SUPPORT
VOID RT_HMAC_SHA1(
	IN const UINT8 Key[],
	IN UINT KeyLen,
	IN const UINT8 Message[],
	IN UINT MessageLen,
	OUT UINT8 MAC[],
	IN UINT MACLen);

#define HMAC_SHA256_SUPPORT
VOID RT_HMAC_SHA256(
	IN const UINT8 Key[],
	IN UINT KeyLen,
	IN const UINT8 Message[],
	IN UINT MessageLen,
	OUT UINT8 MAC[],
	IN UINT MACLen);

void DH_PublicKey_Generate (
	IN UINT8 GValue[],
	IN UINT GValueLength,
	IN UINT8 PValue[],
	IN UINT PValueLength,
	IN UINT8 PrivateKey[],
	IN UINT PrivateKeyLength,
	OUT UINT8 PublicKey[],
	INOUT UINT *PublicKeyLength);

void DH_SecretKey_Generate (
	IN UINT8 PublicKey[],
	IN UINT PublicKeyLength,
	IN UINT8 PValue[],
	IN UINT PValueLength,
	IN UINT8 PrivateKey[],
	IN UINT PrivateKeyLength,
	OUT UINT8 SecretKey[],
	INOUT UINT *SecretKeyLength);


#endif /* __CRYPT_HMAC_H__ */

