/*
 * cleopatre/application/p1905_managerd/inc/cmdu_message_parse.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#ifndef CMDU_MESSAGE_PARSE_H
#define CMDU_MESSAGEPARSE_H

#include <linux/if_ether.h>
#include "p1905_managerd.h"
#include "cmdu_tlv_parse.h"
#include "p1905_utils.h"

int parse_cmdu_message(struct p1905_managerd_ctx *ctx, unsigned char *buf,
    unsigned char *dmac, unsigned char *smac, int len);
char *get_mtype_str_from_msg_hdr(unsigned char *buf);
struct topology_discovery_db *get_tpd_db_by_mac(struct p1905_managerd_ctx *ctx, unsigned char *mac);
struct topology_response_db *get_trsp_db_by_mac(struct p1905_managerd_ctx *ctx, unsigned char *mac);
int delete_not_exist_p1905_neighbor_device(struct p1905_managerd_ctx *ctx,
	int sec);
void delete_not_exist_p1905_topology_device(struct p1905_managerd_ctx *ctx,
	int sec);
void delete_exist_topology_discovery_database(struct p1905_managerd_ctx *ctx,
	unsigned char *al_mac, unsigned char *itf_mac);

void delete_topo_response_db_by_port_interface(struct p1905_managerd_ctx *ctx,
	int port);

int delete_topo_disc_db_by_port(struct p1905_managerd_ctx *ctx,
	int port, unsigned char *exclude_almac);

int delete_p1905_neighbor_dev_info(struct p1905_managerd_ctx *ctx,
	unsigned char *al_mac, unsigned char *recvif_mac);
struct topology_response_db * delete_exist_topology_response_content(
	struct p1905_managerd_ctx *ctx, unsigned char *al_mac);

int insert_topology_discovery_database(struct p1905_managerd_ctx *ctx,
	unsigned char *al_mac, unsigned char *itf_mac, unsigned char *recv_itf_mac);

struct topology_discovery_db * find_discovery_by_almac(
	struct p1905_managerd_ctx *ctx, unsigned char *al_mac);
void find_neighbor_almac_by_intf_mac(
	struct p1905_managerd_ctx *ctx, unsigned char *itf_mac, unsigned char *almac);

struct topology_response_db * find_response_by_almac(
	struct p1905_managerd_ctx *ctx, unsigned char *al_mac);
int find_almac_by_connect_mac(struct p1905_managerd_ctx *ctx,
	unsigned char *mac, unsigned char *almac);
void mask_control_conn_port(struct p1905_managerd_ctx *ctx,
	struct topology_response_db *tpgr_db);
void unmask_control_conn_port(struct p1905_managerd_ctx *ctx, int port);

#endif /* CMDU_MESSAGEPARSE_H */
