/*
 * switch_layer.h: switch layer for MAP
 *
 * Author: Sirui Zhao <Sirui.Zhao@mediatek.com>
 */
#ifndef SWITCH_LAYER_H
#define SWITCH_LAYER_H

#define SWITCH_MAX_PORT	7
#define BIT_OFFSET	16

#define MAX_VLAN        4094 //vaild vid is 1-4094

#define SWITCH_ERROR_COUNTER 10

#define REG_ESW_WT_MAC_ATA1             0x74
#define REG_ESW_WT_MAC_ATA2             0x78
#define REG_ESW_WT_MAC_ATWD             0x7C
#define REG_ESW_WT_MAC_ATC              0x80
#define REG_ESW_TABLE_TSRA1		0x84
#define REG_ESW_TABLE_TSRA2		0x88
#define REG_ESW_TABLE_ATRD		0x8C

#define REG_ESW_VLAN_VTCR		0x90
#define REG_ESW_VLAN_VAWD1		0x94
#define REG_ESW_VLAN_VAWD2		0x98

#if defined (CONFIG_RALINK_MT7628)
#define REG_ESW_VLAN_ID_BASE            0x50
#else
#define REG_ESW_VLAN_ID_BASE            0x100
#endif
#define REG_ESW_VLAN_MEMB_BASE		0x70
#define REG_ESW_TABLE_SEARCH		0x24
#define REG_ESW_TABLE_STATUS0		0x28
#define REG_ESW_TABLE_STATUS1		0x2C
#define REG_ESW_TABLE_STATUS2		0x30

extern struct mt753x_attr *attres;
extern struct eth_ops switch_layer_ops;
#endif
