#ifndef __WAPP_USR_INTF_H__
#define __WAPP_USR_INTF_H__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <errno.h>
#include <assert.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <sys/sem.h>
#include <stddef.h>

#include "list.h"

#include "interface.h"

struct wapp_usr_intf_cmd
{
	struct dl_list list;
	unsigned char* content;
};

struct wapp_usr_intf_cli
{
	struct dl_list list;
	/*client daemon name*/
	char daemon_name[32];
	/*client sock addr*/
	struct sockaddr_un addr;
	socklen_t addrlen;
	/*cmd list from client*/
	struct dl_list cmd_list;
	/*registered event which need to be sent to deamon, total support 256 different events*/
	unsigned char registerd_event_bitmap[32];
	int errors;
};
struct wapp_usr_intf_cli_ctrl
{
	/*wapp interface face ctrl socket, server*/
	int sock;
	/*sock addr*/
	struct sockaddr_un addr;
	/*peer client list*/
	struct dl_list daemon_cli_list;
};

struct client_cmd
{
	struct dl_list list;
	struct cmd_to_wapp* cmd_buf;
};
int retry_socket_send(int sock);

#endif
