/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2011, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	oce.c

	Abstract:

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/
#include <stdlib.h>
#include <stdio.h>
#include "wapp_cmm.h"
#include "oce.h"
#include "driver_wext.h"
#ifdef OCE_SUPPORT

struct oce_event_ops;
extern struct oce_event_ops oce_evnt_ops;


int oce_init(struct oce_cfg *oce)
{
	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);
	oce->event_ops = &oce_evnt_ops;
	return OCE_SUCCESS;
}

int oce_sta_update(
	struct wifi_app *wapp,
	struct wapp_sta *sta,
	u8				action,
	u32				len,
	void			*data)
{
	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);

	if (!wapp || !sta) {
		return OCE_INVALID_ARG;
	}

	switch(action)
	{
		case OCE_CAP_UPDATE:
		{
			if (len == sizeof(u8))
				sta->oce_cap= *((u8 *) data);
			break;
		}

		case OCE_DELASSRSSI_UPDATE:
		{
			if (len == sizeof(u32))
				sta->deltaassocrssi = *((u32 *) data);
			break;
		}

		default:
			break;
	}
	return OCE_SUCCESS;
}

int oce_event_sta_update(struct wifi_app *wapp, char *msg, u8 msg_type)
{
	struct wapp_sta *sta = NULL;
	struct oce_msg *pmsg = (struct oce_msg *) msg;
	struct oce_info *info = &pmsg->body.OceEvtStaInfo;
	struct wapp_dev *wdev = NULL;
	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);

	wdev = wapp_dev_list_lookup_by_ifindex(wapp, pmsg->ifindex);

	if (!wdev)
		return OCE_LOOKUP_ENTRY_NOT_FOUND;

	sta = wdev_ap_client_list_lookup(wapp, (struct ap_dev *) wdev->p_dev, info->mac_addr);

	if (!sta)
		return OCE_LOOKUP_ENTRY_NOT_FOUND;

	switch(msg_type)
	{
		case OCE_MSG_INFO_UPDATE:
			printf("\033[1;32m %s, %u info->OceCapIndication 0x%x\033[0m\n"
				, __FUNCTION__, __LINE__,info->OceCapIndication);
			oce_sta_update(	wapp,
							sta,
							OCE_CAP_UPDATE,
							sizeof(sta->oce_cap),
							(void *) &info->OceCapIndication);
			oce_sta_update(	wapp,
							sta,
							OCE_DELASSRSSI_UPDATE,
							sizeof(sta->deltaassocrssi),
							(void *) &info->DeltaAssocRSSI);
			break;
		default:
			break;
	}

	return OCE_SUCCESS;
}

struct oce_event_ops oce_evnt_ops = {
	.sta_update = oce_event_sta_update,
};

#endif /* OCE_SUPPORT */

